/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.jbosscl.test;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashSet;
import org.jboss.test.classpool.jbosscl.support.CLDeploymentBuilder;
import org.jboss.test.classpool.jbosscl.support.SupportArchives;
import org.jboss.test.classpool.jbosscl.support.SupportClasses;
import org.jboss.test.classpool.jbosscl.test.JBossClClassPoolTest;
import org.jboss.test.classpool.support.ClassLoaderInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryTest<C, L>
extends JBossClClassPoolTest<C, L> {
    private Collection<ClassLoader> createdURLClassLoaders = new HashSet<ClassLoader>();

    public RepositoryTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            this.createdURLClassLoaders.clear();
        }
    }

    public void testGlobalScope() throws Exception {
        CLDeploymentBuilder clBuilderA = new CLDeploymentBuilder("A", SupportArchives.JAR_A_URL);
        Object loaderA = this.testScenario.createLoader((ClassLoaderInfo)clBuilderA);
        CLDeploymentBuilder clBuilderB = new CLDeploymentBuilder("B", SupportArchives.JAR_B_URL);
        Object loaderB = this.testScenario.createLoader((ClassLoaderInfo)clBuilderB);
        Object aFromA = this.testScenario.loadClass(loaderA, SupportClasses.CLASS_A);
        Object bFromA = this.testScenario.loadClass(loaderA, loaderB, SupportClasses.CLASS_B);
        Object aFromB = this.testScenario.loadClass(loaderB, loaderA, SupportClasses.CLASS_A);
        Object bFromB = this.testScenario.loadClass(loaderB, SupportClasses.CLASS_B);
        RepositoryTest.assertSame((Object)aFromA, (Object)aFromB);
        RepositoryTest.assertSame((Object)bFromA, (Object)bFromB);
        this.testScenario.destroyLoader((ClassLoaderInfo)clBuilderB);
        aFromA = this.testScenario.loadClass(loaderA, SupportClasses.CLASS_A);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_B);
    }

    public void testChildDomain() throws Exception {
        Object loaderA = this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("A", SupportArchives.JAR_A_URL));
        Object loaderB = this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("B", SupportArchives.JAR_B_URL));
        CLDeploymentBuilder childCLBuilder = new CLDeploymentBuilder("C", SupportArchives.JAR_C_URL);
        childCLBuilder.createDomain("CHILD", true);
        Object childLoader = this.testScenario.createLoader((ClassLoaderInfo)childCLBuilder);
        Object aFromA = this.testScenario.loadClass(loaderA, SupportClasses.CLASS_A);
        Object bFromB = this.testScenario.loadClass(loaderB, SupportClasses.CLASS_B);
        this.testScenario.loadClass(childLoader, SupportClasses.CLASS_C);
        Object aFromC = this.testScenario.loadClass(childLoader, loaderA, SupportClasses.CLASS_A);
        Object bFromC = this.testScenario.loadClass(childLoader, loaderB, SupportClasses.CLASS_B);
        RepositoryTest.assertSame((Object)aFromA, (Object)aFromC);
        RepositoryTest.assertSame((Object)bFromB, (Object)bFromC);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_C);
        this.testScenario.cannotLoadClass(loaderB, SupportClasses.CLASS_C);
    }

    public void testSiblingDomains() throws Exception {
        CLDeploymentBuilder clBuilderA = new CLDeploymentBuilder("A", SupportArchives.JAR_A_URL);
        clBuilderA.createDomain("ChildA", true);
        Object loaderA = this.testScenario.createLoader((ClassLoaderInfo)clBuilderA);
        CLDeploymentBuilder clBuilderB = new CLDeploymentBuilder("B", SupportArchives.JAR_B_URL);
        clBuilderB.createDomain("ChildB", true);
        Object loaderB = this.testScenario.createLoader((ClassLoaderInfo)clBuilderB);
        this.testScenario.loadClass(loaderA, SupportClasses.CLASS_A);
        this.testScenario.loadClass(loaderB, SupportClasses.CLASS_B);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_B);
        this.testScenario.cannotLoadClass(loaderB, SupportClasses.CLASS_A);
    }

    public void testChildWithNewClassesInParent() throws Exception {
        CLDeploymentBuilder clScopedBuilder = new CLDeploymentBuilder("SCOPED", SupportArchives.JAR_B_URL);
        clScopedBuilder.createDomain("SCOPED", true);
        Object scopedLoader = this.testScenario.createLoader((ClassLoaderInfo)clScopedBuilder);
        this.testScenario.cannotLoadClass(scopedLoader, SupportClasses.CLASS_A);
        Object globalLoader = this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("GLOBAL", SupportArchives.JAR_A_URL));
        Object aFromChild = this.testScenario.loadClass(scopedLoader, globalLoader, SupportClasses.CLASS_A);
        Object aFromParent = this.testScenario.loadClass(globalLoader, SupportClasses.CLASS_A);
        RepositoryTest.assertSame((Object)aFromChild, (Object)aFromParent);
    }

    public void testChildOverrideWithParentDelegation() throws Exception {
        Object globalLoader = this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("GLOBAL", SupportArchives.JAR_A_URL));
        CLDeploymentBuilder clScopedBuilder = new CLDeploymentBuilder("SCOPED", SupportArchives.JAR_B_URL);
        clScopedBuilder.createDomain("SCOPED", true);
        Object scopedLoader = this.testScenario.createLoader((ClassLoaderInfo)clScopedBuilder);
        Object aFromParent = this.testScenario.loadClass(globalLoader, SupportClasses.CLASS_A);
        Object aFromChild = this.testScenario.loadClass(scopedLoader, globalLoader, SupportClasses.CLASS_A);
        RepositoryTest.assertSame((Object)aFromParent, (Object)aFromChild);
    }

    public void testChildOverrideWithNoParentDelegation() throws Exception {
        Object globalLoader = this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("GLOBAL", SupportArchives.JAR_A_URL));
        CLDeploymentBuilder clScopedBuilder = new CLDeploymentBuilder("CHILD", SupportArchives.JAR_A_URL);
        clScopedBuilder.createDomain("CHILD", false);
        Object scopedLoader = this.testScenario.createLoader((ClassLoaderInfo)clScopedBuilder);
        Object aFromParent = this.testScenario.loadClass(globalLoader, SupportClasses.CLASS_A);
        Object aFromChild = this.testScenario.loadClass(scopedLoader, SupportClasses.CLASS_A);
        RepositoryTest.assertNotSame((Object)aFromParent, (Object)aFromChild);
    }

    public void testURLChildOfGlobalUcl() throws Exception {
        Object globalLoader = this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("GLOBAL", SupportArchives.JAR_A_URL));
        Object childALoader = this.createChildURLLoader(globalLoader, SupportArchives.JAR_B_URL);
        this.testScenario.loadClass(childALoader, globalLoader, SupportClasses.CLASS_A);
        this.testScenario.loadClass(childALoader, SupportClasses.CLASS_B);
        Object childBLoader = this.createChildURLLoader(globalLoader, SupportArchives.JAR_A_URL);
        this.testScenario.loadClass(childBLoader, globalLoader, SupportClasses.CLASS_A);
    }

    public void testUndeploySibling() throws Exception {
        Object globalLoader = this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("GLOBAL", SupportArchives.JAR_A_URL));
        this.testScenario.cannotLoadClass(globalLoader, SupportClasses.CLASS_B);
        CLDeploymentBuilder bCLBuilder = new CLDeploymentBuilder("B", SupportArchives.JAR_B_URL);
        Object bLoader = this.testScenario.createLoader((ClassLoaderInfo)bCLBuilder);
        this.testScenario.loadClass(globalLoader, bLoader, SupportClasses.CLASS_B);
        this.testScenario.destroyLoader((ClassLoaderInfo)bCLBuilder);
        this.testScenario.cannotLoadClass(globalLoader, SupportClasses.CLASS_B);
    }

    public void testUndeployParentDomainClassLoader() throws Exception {
        Object globalLoaderA = this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("GLOBAL", SupportArchives.JAR_A_URL));
        this.testScenario.cannotLoadClass(globalLoaderA, SupportClasses.CLASS_B);
        CLDeploymentBuilder childCLBuilder = new CLDeploymentBuilder("C", SupportArchives.JAR_C_URL);
        childCLBuilder.createDomain("C", false);
        Object childLoader = this.testScenario.createLoader((ClassLoaderInfo)childCLBuilder);
        this.testScenario.cannotLoadClass(childLoader, SupportClasses.CLASS_B);
        CLDeploymentBuilder globalCLBuilderB = new CLDeploymentBuilder("B", SupportArchives.JAR_B_URL);
        Object globalLoaderB = this.testScenario.createLoader((ClassLoaderInfo)globalCLBuilderB);
        Object bFromChild = this.testScenario.loadClass(childLoader, globalLoaderB, SupportClasses.CLASS_B);
        Object bFromA = this.testScenario.loadClass(globalLoaderA, globalLoaderB, SupportClasses.CLASS_B);
        RepositoryTest.assertSame((Object)bFromA, (Object)bFromChild);
        this.testScenario.destroyLoader((ClassLoaderInfo)globalCLBuilderB);
        this.testScenario.cannotLoadClass(childLoader, SupportClasses.CLASS_B);
    }

    public void testClassLoaderWithParentClassLoader() throws Exception {
        Object parentLoader = this.createChildURLLoader(null, SupportArchives.JAR_B_URL);
        CLDeploymentBuilder globalCLBuilder = new CLDeploymentBuilder("A", SupportArchives.JAR_A_URL);
        globalCLBuilder.createDomain("A", this.testScenario.getClassLoader(parentLoader), true);
        Object globalLoader = this.testScenario.createLoader((ClassLoaderInfo)globalCLBuilder);
        this.testScenario.loadClass(globalLoader, SupportClasses.CLASS_A);
        Object bFromGlobal = this.testScenario.loadClass(globalLoader, parentLoader, SupportClasses.CLASS_B);
        Object bFromParent = this.testScenario.loadClass(parentLoader, SupportClasses.CLASS_B);
        RepositoryTest.assertSame((Object)bFromGlobal, (Object)bFromParent);
        this.testScenario.cannotLoadClass(parentLoader, SupportClasses.CLASS_A);
    }

    public void testClassLoaderWithParentClassLoaderAndCrossReference() throws Exception {
        Object parentLoader = this.createChildURLLoader(null, SupportArchives.JAR_B_URL);
        CLDeploymentBuilder globalCLBuilder = new CLDeploymentBuilder("D", SupportArchives.JAR_D_URL);
        globalCLBuilder.createDomain("D", this.testScenario.getClassLoader(parentLoader), true);
        Object globalLoader = this.testScenario.createLoader((ClassLoaderInfo)globalCLBuilder);
        Object dFromGlobal = this.testScenario.loadClass(globalLoader, SupportClasses.CLASS_D);
        Object bFromGlobal = this.testScenario.loadClass(globalLoader, parentLoader, SupportClasses.CLASS_B);
        Object bFromParent = this.testScenario.loadClass(parentLoader, SupportClasses.CLASS_B);
        RepositoryTest.assertSame((Object)bFromGlobal, (Object)bFromParent);
        this.testScenario.cannotLoadClass(parentLoader, SupportClasses.CLASS_D);
        Object returnType = this.testScenario.getMethodReturnType(dFromGlobal, "getB");
        RepositoryTest.assertSame((Object)returnType, (Object)bFromParent);
    }

    public void testClassLoaderWithParentClassLoaderAndSameClassInDomain() throws Exception {
        Object parentLoader = this.createChildURLLoader(null, SupportArchives.JAR_B_URL);
        String domain = "CHILD";
        CLDeploymentBuilder globalCLBuilderA = new CLDeploymentBuilder("A", SupportArchives.JAR_A_URL);
        globalCLBuilderA.createDomain(domain, this.testScenario.getClassLoader(parentLoader), true);
        Object globalLoaderA = this.testScenario.createLoader((ClassLoaderInfo)globalCLBuilderA);
        this.testScenario.loadClass(globalLoaderA, SupportClasses.CLASS_A);
        Object bFromGlobalA = this.testScenario.loadClass(globalLoaderA, parentLoader, SupportClasses.CLASS_B);
        CLDeploymentBuilder globalCLBuilderB = new CLDeploymentBuilder("B", SupportArchives.JAR_B_URL);
        globalCLBuilderB.setDomain(domain);
        Object globalLoaderB = this.testScenario.createLoader((ClassLoaderInfo)globalCLBuilderB);
        Object bFromParent = this.testScenario.loadClass(parentLoader, SupportClasses.CLASS_B);
        RepositoryTest.assertSame((Object)bFromGlobalA, (Object)bFromParent);
        Object bFromGlobalB = this.testScenario.loadClass(globalLoaderB, parentLoader, SupportClasses.CLASS_B);
        RepositoryTest.assertSame((Object)bFromGlobalB, (Object)bFromParent);
        CLDeploymentBuilder globalCLBuilderC = new CLDeploymentBuilder("C", SupportArchives.JAR_B_URL);
        globalCLBuilderC.createDomain(domain + "2", this.testScenario.getClassLoader(parentLoader), false);
        Object globalLoaderC = this.testScenario.createLoader((ClassLoaderInfo)globalCLBuilderC);
        this.testScenario.loadClass(globalLoaderC, SupportClasses.CLASS_B);
    }

    public void testSeveralLevelsOfDomain() throws Exception {
        Object parentLoader = this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("A", SupportArchives.JAR_A_URL));
        Object aFromParent = this.testScenario.loadClass(parentLoader, SupportClasses.CLASS_A);
        String domain1 = "1";
        CLDeploymentBuilder clDeploymentBuilder1B = new CLDeploymentBuilder("1B", SupportArchives.JAR_B_URL);
        clDeploymentBuilder1B.createDomain(domain1, true);
        Object loader1B = this.testScenario.createLoader((ClassLoaderInfo)clDeploymentBuilder1B);
        CLDeploymentBuilder clDeploymentBuilder1C = new CLDeploymentBuilder("1C", SupportArchives.JAR_C_URL);
        clDeploymentBuilder1C.setDomain(domain1);
        Object loader1C = this.testScenario.createLoader((ClassLoaderInfo)clDeploymentBuilder1C);
        Object aFrom1B = this.testScenario.loadClass(loader1B, parentLoader, SupportClasses.CLASS_A);
        Object bFrom1B = this.testScenario.loadClass(loader1B, SupportClasses.CLASS_B);
        Object cFrom1B = this.testScenario.loadClass(loader1B, loader1C, SupportClasses.CLASS_C);
        Object aFrom1C = this.testScenario.loadClass(loader1C, parentLoader, SupportClasses.CLASS_A);
        Object bFrom1C = this.testScenario.loadClass(loader1C, loader1B, SupportClasses.CLASS_B);
        Object cFrom1C = this.testScenario.loadClass(loader1C, SupportClasses.CLASS_C);
        RepositoryTest.assertSame((Object)aFromParent, (Object)aFrom1B);
        RepositoryTest.assertSame((Object)aFromParent, (Object)aFrom1C);
        RepositoryTest.assertSame((Object)bFrom1B, (Object)bFrom1C);
        RepositoryTest.assertSame((Object)cFrom1B, (Object)cFrom1C);
        String domain2 = "2";
        CLDeploymentBuilder clDeploymentBuilder2B = new CLDeploymentBuilder("2B", SupportArchives.JAR_B_URL);
        clDeploymentBuilder2B.createDomain(domain2, true);
        Object loader2B = this.testScenario.createLoader((ClassLoaderInfo)clDeploymentBuilder2B);
        CLDeploymentBuilder clDeploymentBuilder2C = new CLDeploymentBuilder("2C", SupportArchives.JAR_C_URL);
        clDeploymentBuilder2C.setDomain(domain2);
        Object loader2C = this.testScenario.createLoader((ClassLoaderInfo)clDeploymentBuilder2C);
        Object aFrom2B = this.testScenario.loadClass(loader2B, parentLoader, SupportClasses.CLASS_A);
        Object bFrom2B = this.testScenario.loadClass(loader2B, SupportClasses.CLASS_B);
        Object cFrom2B = this.testScenario.loadClass(loader2B, loader2C, SupportClasses.CLASS_C);
        Object aFrom2C = this.testScenario.loadClass(loader2C, parentLoader, SupportClasses.CLASS_A);
        Object bFrom2C = this.testScenario.loadClass(loader2C, loader2B, SupportClasses.CLASS_B);
        Object cFrom2C = this.testScenario.loadClass(loader2C, SupportClasses.CLASS_C);
        RepositoryTest.assertSame((Object)aFromParent, (Object)aFrom2B);
        RepositoryTest.assertSame((Object)aFromParent, (Object)aFrom2C);
        RepositoryTest.assertSame((Object)bFrom2B, (Object)bFrom2C);
        RepositoryTest.assertSame((Object)cFrom2B, (Object)cFrom2C);
        RepositoryTest.assertNotSame((Object)bFrom1B, (Object)bFrom2B);
        RepositoryTest.assertNotSame((Object)bFrom2C, (Object)bFrom1C);
        RepositoryTest.assertNotSame((Object)cFrom2C, (Object)cFrom1C);
        String domain11 = "11";
        CLDeploymentBuilder clBuilder11A = new CLDeploymentBuilder("11A", SupportArchives.JAR_A_URL);
        clBuilder11A.createDomain("11", domain1, true);
        Object loader11A = this.testScenario.createLoader((ClassLoaderInfo)clBuilder11A);
        CLDeploymentBuilder clBuilder11B = new CLDeploymentBuilder("11B", SupportArchives.JAR_B_URL);
        clBuilder11B.setDomain("11");
        Object loader11B = this.testScenario.createLoader((ClassLoaderInfo)clBuilder11B);
        CLDeploymentBuilder clBuilder11C = new CLDeploymentBuilder("11C", SupportArchives.JAR_C_URL);
        clBuilder11C.setDomain("11");
        Object loader11C = this.testScenario.createLoader((ClassLoaderInfo)clBuilder11C);
        String domain12 = "12";
        CLDeploymentBuilder clBuilder12A = new CLDeploymentBuilder("12A", SupportArchives.JAR_A_URL);
        clBuilder12A.createDomain(domain12, domain1, false);
        Object loader12A = this.testScenario.createLoader((ClassLoaderInfo)clBuilder12A);
        CLDeploymentBuilder clBuilder12B = new CLDeploymentBuilder("12B", SupportArchives.JAR_B_URL);
        clBuilder12B.setDomain(domain12);
        Object loader12B = this.testScenario.createLoader((ClassLoaderInfo)clBuilder12B);
        CLDeploymentBuilder clBuilder12C = new CLDeploymentBuilder("12C", SupportArchives.JAR_C_URL);
        clBuilder12C.setDomain(domain12);
        Object loader12C = this.testScenario.createLoader((ClassLoaderInfo)clBuilder12C);
        Object aFrom11A = this.testScenario.loadClass(loader11A, parentLoader, SupportClasses.CLASS_A);
        Object aFrom11B = this.testScenario.loadClass(loader11B, parentLoader, SupportClasses.CLASS_A);
        Object aFrom11C = this.testScenario.loadClass(loader11C, parentLoader, SupportClasses.CLASS_A);
        RepositoryTest.assertSame((Object)aFromParent, (Object)aFrom11A);
        RepositoryTest.assertSame((Object)aFromParent, (Object)aFrom11B);
        RepositoryTest.assertSame((Object)aFromParent, (Object)aFrom11C);
        Object aFrom12A = this.testScenario.loadClass(loader12A, SupportClasses.CLASS_A);
        Object aFrom12B = this.testScenario.loadClass(loader12B, loader12A, SupportClasses.CLASS_A);
        Object aFrom12C = this.testScenario.loadClass(loader12C, loader12A, SupportClasses.CLASS_A);
        RepositoryTest.assertNotSame((Object)aFromParent, (Object)aFrom12A);
        RepositoryTest.assertSame((Object)aFrom12A, (Object)aFrom12B);
        RepositoryTest.assertSame((Object)aFrom12A, (Object)aFrom12C);
        Object bFrom11A = this.testScenario.loadClass(loader11A, loader1B, SupportClasses.CLASS_B);
        Object bFrom11B = this.testScenario.loadClass(loader11B, loader1B, SupportClasses.CLASS_B);
        Object bFrom11C = this.testScenario.loadClass(loader11C, loader1B, SupportClasses.CLASS_B);
        RepositoryTest.assertSame((Object)bFrom11A, (Object)bFrom11B);
        RepositoryTest.assertSame((Object)bFrom11A, (Object)bFrom11C);
        Object cFrom11A = this.testScenario.loadClass(loader11A, loader1C, SupportClasses.CLASS_C);
        Object cFrom11B = this.testScenario.loadClass(loader11B, loader1C, SupportClasses.CLASS_C);
        Object cFrom11C = this.testScenario.loadClass(loader11C, loader1C, SupportClasses.CLASS_C);
        RepositoryTest.assertSame((Object)cFrom11A, (Object)cFrom11B);
        RepositoryTest.assertSame((Object)cFrom11A, (Object)cFrom11C);
        Object bFrom12A = this.testScenario.loadClass(loader12A, loader12B, SupportClasses.CLASS_B);
        Object bFrom12B = this.testScenario.loadClass(loader12B, SupportClasses.CLASS_B);
        Object bFrom12C = this.testScenario.loadClass(loader12C, loader12B, SupportClasses.CLASS_B);
        RepositoryTest.assertSame((Object)bFrom12A, (Object)bFrom12B);
        RepositoryTest.assertSame((Object)bFrom12A, (Object)bFrom12C);
        RepositoryTest.assertNotSame((Object)bFrom11B, (Object)bFrom12B);
        Object cFrom12A = this.testScenario.loadClass(loader12A, loader12C, SupportClasses.CLASS_C);
        Object cFrom12B = this.testScenario.loadClass(loader12B, loader12C, SupportClasses.CLASS_C);
        Object cFrom12C = this.testScenario.loadClass(loader12C, SupportClasses.CLASS_C);
        RepositoryTest.assertSame((Object)cFrom12A, (Object)cFrom12B);
        RepositoryTest.assertSame((Object)cFrom12A, (Object)cFrom12C);
        RepositoryTest.assertNotSame((Object)cFrom11C, (Object)cFrom12C);
    }

    public void testUclLoaderOrdering() throws Exception {
        Object globalLoaderA1 = this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("A1", SupportArchives.JAR_A_URL));
        Object globalLoaderA2 = this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("A2", SupportArchives.JAR_A_URL));
        Object globalLoaderA3 = this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("A3", SupportArchives.JAR_A_URL));
        this.testScenario.loadClass(globalLoaderA1, SupportClasses.CLASS_A);
        this.testScenario.loadClass(globalLoaderA2, globalLoaderA1, SupportClasses.CLASS_A);
        this.testScenario.loadClass(globalLoaderA3, globalLoaderA1, SupportClasses.CLASS_A);
    }

    protected L createChildURLLoader(L parentLoader, URL url) {
        ClassLoader parentClassLoader = parentLoader == null ? null : this.testScenario.getClassLoader(parentLoader);
        URLClassLoader classLoader = new URLClassLoader(new URL[]{url}, parentClassLoader);
        this.createdURLClassLoaders.add(classLoader);
        return (L)this.testScenario.getLoader((ClassLoader)classLoader);
    }
}

