/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.async.spi;

import java.util.concurrent.Callable;
import org.jboss.ejb3.async.spi.AsyncInvocationId;
import org.jboss.ejb3.async.spi.SecurityActions;
import org.jboss.security.SecurityContext;

public abstract class AsyncInvocationTaskBase<V>
implements Callable<V> {
    protected final SecurityContext sc;
    private final ClassLoader invokingCl;
    protected final AsyncInvocationId id;

    public AsyncInvocationTaskBase(SecurityContext sc, AsyncInvocationId id, ClassLoader invokingCl) {
        assert (id != null) : "Async Invocation ID must be supplied";
        assert (invokingCl != null) : "CL must be supplied";
        this.sc = sc;
        this.id = id;
        this.invokingCl = invokingCl;
    }

    protected abstract void before() throws Exception;

    protected abstract V proceed() throws Throwable;

    protected abstract void after() throws Exception;

    @Override
    public final V call() throws Exception {
        SecurityContext oldSc = SecurityActions.getSecurityContext();
        ClassLoader oldCl = SecurityActions.getTccl();
        try {
            this.before();
            SecurityActions.setTccl(this.invokingCl);
            SecurityActions.setSecurityContext(this.sc);
            V v = this.proceed();
            return v;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new Error(t);
        }
        finally {
            SecurityActions.setSecurityContext(oldSc);
            SecurityActions.setTccl(oldCl);
            this.after();
        }
    }
}

