/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.async.spi;

import java.lang.reflect.Method;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.spec.AsyncMethodMetaData;
import org.jboss.metadata.ejb.spec.AsyncMethodsMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;

public class AsyncUtil {
    private static final Logger log = Logger.getLogger(AsyncUtil.class);

    private AsyncUtil() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    public static boolean methodIsAsynchronous(Method invokedMethod, AsyncMethodsMetaData asyncMethodsForBean) {
        for (AsyncMethodMetaData asyncMethod : asyncMethodsForBean) {
            String invokedMethodName = invokedMethod.getName();
            if (!invokedMethodName.equals(asyncMethod.getMethodName())) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Async method names match: " + invokedMethodName));
            }
            MethodParametersMetaData asyncParams = asyncMethod.getMethodParams();
            Class<?>[] invokedParams = invokedMethod.getParameterTypes();
            int invokedParamsSize = invokedParams.length;
            if (asyncParams.size() != invokedParams.length) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Different async params size, no match");
                }
                return false;
            }
            for (int i = 0; i < invokedParamsSize; ++i) {
                String declaredName;
                String invokedParamTypeName = invokedParams[i].getName();
                if (invokedParamTypeName.equals(declaredName = (String)asyncParams.get(i))) continue;
                return false;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Marked as @Asynchronous: " + invokedMethod));
            }
            return true;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Not @Asynchronous: " + invokedMethod));
        }
        return false;
    }
}

