/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.concurrency.aop.interceptor;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import javax.ejb.AccessTimeout;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.Lock;
import javax.ejb.LockType;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.concurrency.impl.EJBReadWriteLock;

public class ContainerManagedConcurrencyInterceptor
implements Interceptor {
    private ReadWriteLock readWriteLock = new EJBReadWriteLock();

    private AccessTimeout getAccessTimeout(Invocation invocation) {
        AccessTimeout timeout = (AccessTimeout)invocation.resolveAnnotation(AccessTimeout.class);
        if (timeout == null) {
            timeout = (AccessTimeout)invocation.resolveClassAnnotation(AccessTimeout.class);
        }
        return timeout;
    }

    private java.util.concurrent.locks.Lock getLock(Invocation invocation) {
        LockType lockType = this.getLockType(invocation);
        switch (lockType) {
            case READ: {
                return this.readWriteLock.readLock();
            }
            case WRITE: {
                return this.readWriteLock.writeLock();
            }
        }
        throw new IllegalStateException("Illegal lock type " + lockType + " on " + invocation);
    }

    private LockType getLockType(Invocation invocation) {
        Lock lock = (Lock)invocation.resolveAnnotation(Lock.class);
        if (lock == null) {
            lock = (Lock)invocation.resolveClassAnnotation(Lock.class);
        }
        if (lock == null) {
            return LockType.WRITE;
        }
        return lock.value();
    }

    public String getName() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        boolean success;
        java.util.concurrent.locks.Lock lock = this.getLock(invocation);
        long time = 5L;
        TimeUnit unit = TimeUnit.MINUTES;
        AccessTimeout timeout = this.getAccessTimeout(invocation);
        if (timeout != null) {
            time = timeout.value();
            unit = timeout.unit();
        }
        if (!(success = lock.tryLock(time, unit))) {
            throw new ConcurrentAccessTimeoutException("EJB 3.1 PFD2 4.8.5.5.1 concurrent access timeout on " + invocation);
        }
        try {
            Object object = invocation.invokeNext();
            return object;
        }
        finally {
            lock.unlock();
        }
    }
}

