/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.util.ArrayList;
import java.util.Collection;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.process.chain.ProcessorChain;
import org.jboss.metadata.process.chain.ejb.jboss.JBossMetaDataProcessorChain;
import org.jboss.metadata.process.processor.JBossMetaDataProcessor;
import org.jboss.metadata.process.processor.ejb.jboss.ClusterConfigDefaultValueProcessor;
import org.jboss.metadata.process.processor.ejb.jboss.JBossMetaDataValidatorChainProcessor;
import org.jboss.metadata.process.processor.ejb.jboss.SetDefaultLocalBusinessInterfaceProcessor;
import org.jboss.metadata.process.processor.ejb.jboss.SetExplicitLocalJndiNameProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3MetadataProcessingDeployer
extends AbstractDeployer {
    private static final Logger log = Logger.getLogger(Ejb3MetadataProcessingDeployer.class);
    private static final String INPUT = "merged." + JBossMetaData.class.getName();
    public static final String OUTPUT = "processed." + JBossMetaData.class.getName();

    public Ejb3MetadataProcessingDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addInput(INPUT);
        this.addOutput(OUTPUT);
    }

    public void deploy(DeploymentUnit du) throws DeploymentException {
        JBossMetaData md = (JBossMetaData)du.getAttachment(INPUT, JBossMetaData.class);
        if (md == null) {
            return;
        }
        if (!md.isEJB3x()) {
            return;
        }
        ProcessorChain<JBossMetaData> chain = this.getProcessorChain(du);
        JBossMetaData processedMetadata = chain.process(md);
        du.addAttachment(OUTPUT, (Object)processedMetadata, JBossMetaData.class);
    }

    protected ProcessorChain<JBossMetaData> getProcessorChain(DeploymentUnit du) {
        JBossMetaDataProcessorChain chain = new JBossMetaDataProcessorChain();
        StringBuffer logMessage = new StringBuffer("Creating ");
        logMessage.append(ProcessorChain.class.getSimpleName());
        logMessage.append(" with the following Processors:");
        Collection<JBossMetaDataProcessor<JBossMetaData>> processors = this.getProcessors(du);
        if (processors != null) {
            for (JBossMetaDataProcessor<JBossMetaData> processor : processors) {
                chain.addProcessor(processor);
                logMessage.append(" ");
                logMessage.append(processor);
            }
        }
        log.debug((Object)logMessage.toString());
        return chain;
    }

    protected Collection<JBossMetaDataProcessor<JBossMetaData>> getProcessors(DeploymentUnit du) {
        ArrayList<JBossMetaDataProcessor<JBossMetaData>> processors = new ArrayList<JBossMetaDataProcessor<JBossMetaData>>();
        ClassLoader deploymentCl = du.getClassLoader();
        processors.add((JBossMetaDataProcessor<JBossMetaData>)new SetDefaultLocalBusinessInterfaceProcessor(deploymentCl));
        processors.add((JBossMetaDataProcessor<JBossMetaData>)ClusterConfigDefaultValueProcessor.INSTANCE);
        processors.add((JBossMetaDataProcessor<JBossMetaData>)SetExplicitLocalJndiNameProcessor.INSTANCE);
        processors.add((JBossMetaDataProcessor<JBossMetaData>)JBossMetaDataValidatorChainProcessor.INSTANCE);
        return processors;
    }
}

