/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.AnnotatedClassFilter;
import org.jboss.metadata.annotation.creator.ejb.jboss.JBoss50Creator;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.annotation.finder.DefaultAnnotationFinder;
import org.jboss.metadata.ejb.jboss.JBoss50MetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbAnnotationMetaDataDeployer
extends AbstractDeployer {
    public static final String EJB_ANNOTATED_ATTACHMENT_NAME = "annotated." + EjbJarMetaData.class.getName();

    public EjbAnnotationMetaDataDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addInput(EjbJarMetaData.class);
        this.addOutput(EJB_ANNOTATED_ATTACHMENT_NAME);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (!(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        this.deploy(vfsDeploymentUnit);
    }

    protected void deploy(VFSDeploymentUnit unit) throws DeploymentException {
        boolean isComplete = false;
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)unit.getAttachment(EjbJarMetaData.class);
        if (ejbJarMetaData != null && ejbJarMetaData instanceof EjbJar3xMetaData) {
            isComplete |= ((EjbJar3xMetaData)ejbJarMetaData).isMetadataComplete();
        }
        if (isComplete) {
            this.log.debug((Object)("Deployment is metadata-complete, skipping annotation processing, ejbJarMetaData=" + ejbJarMetaData));
            return;
        }
        VirtualFile root = unit.getRoot();
        boolean isLeaf = true;
        try {
            isLeaf = root.isLeaf();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        if (isLeaf) {
            return;
        }
        List classpath = unit.getClassPath();
        if (classpath == null || classpath.isEmpty()) {
            return;
        }
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("Deploying annotations for unit: " + unit + ", classpath: " + classpath));
        }
        try {
            this.processMetaData(unit, classpath);
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException((String)"Cannot process metadata", (Throwable)e);
        }
    }

    protected Collection<Class<?>> getClasses(VFSDeploymentUnit unit, List<VirtualFile> classpath) throws IOException {
        HashMap classpathClasses = new HashMap();
        for (VirtualFile path : classpath) {
            AnnotatedClassFilter classVisitor = new AnnotatedClassFilter(unit, unit.getClassLoader(), path, null);
            path.visit((VirtualFileVisitor)classVisitor);
            Map classes = classVisitor.getAnnotatedClasses();
            if (classes == null || classes.size() <= 0) continue;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Annotated classes: " + classes));
            }
            classpathClasses.putAll(classes);
        }
        return classpathClasses.values();
    }

    protected void processJBossMetaData(VFSDeploymentUnit unit, AnnotationFinder<AnnotatedElement> finder, Collection<Class<?>> classes) {
        JBoss50Creator creator = new JBoss50Creator(finder);
        JBoss50MetaData annotationMetaData = creator.create(classes);
        if (annotationMetaData != null) {
            unit.addAttachment(EJB_ANNOTATED_ATTACHMENT_NAME, (Object)annotationMetaData, JBossMetaData.class);
        }
    }

    protected void processMetaData(VFSDeploymentUnit unit, List<VirtualFile> classpath) throws IOException {
        Collection<Class<?>> classes = this.getClasses(unit, classpath);
        if (classes.size() > 0) {
            DefaultAnnotationFinder finder = new DefaultAnnotationFinder();
            this.processJBossMetaData(unit, (AnnotationFinder<AnnotatedElement>)finder, classes);
        }
    }
}

