/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.ejb.EJBContainer;
import org.jboss.bootstrap.spi.config.ServerConfig;
import org.jboss.bootstrap.spi.mc.config.MCServerConfig;
import org.jboss.bootstrap.spi.mc.config.MCServerConfigFactory;
import org.jboss.bootstrap.spi.mc.server.MCServer;
import org.jboss.bootstrap.spi.mc.server.MCServerFactory;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloading.spi.vfs.policy.VFSClassLoaderPolicy;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.ejb3.api.spi.EJBContainerWrapper;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

public class JBossEJBContainer
extends EJBContainer {
    private static final Logger log = Logger.getLogger(JBossEJBContainer.class);
    private ClassLoader classLoader;
    private MCServer server;
    private Kernel kernel;
    private MainDeployer mainDeployer;

    public static JBossEJBContainer on(EJBContainer container) {
        if (container == null) {
            throw new IllegalArgumentException("container is null");
        }
        if (container instanceof EJBContainerWrapper) {
            return JBossEJBContainer.on(((EJBContainerWrapper)container).getDelegate());
        }
        if (container instanceof JBossEJBContainer) {
            return (JBossEJBContainer)container;
        }
        throw new IllegalArgumentException(container + " is not an instance of JBossEJBContainer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JBossEJBContainer(Map<?, ?> properties, String ... modules) throws Throwable {
        try {
            VirtualFile[] roots = new VirtualFile[]{};
            this.classLoader = ClassLoaderSystem.getInstance().registerClassLoaderPolicy((ClassLoaderPolicy)VFSClassLoaderPolicy.createVFSClassLoaderPolicy((String)"preboot-cl", (VirtualFile[])roots));
            URL confURL = this.classLoader.getResource("conf");
            if (confURL == null) {
                throw new IllegalStateException("can't find a 'conf' directory on the classpath of " + this.classLoader);
            }
            MCServerConfig config = MCServerConfigFactory.createServerConfig((ClassLoader)this.classLoader);
            config.bootstrapHome(confURL);
            MCServer server = MCServerFactory.createServer((ClassLoader)this.classLoader);
            server.setConfiguration((ServerConfig)config);
            server.initialize();
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                server.start();
                this.kernel = server.getKernel();
                this.mainDeployer = this.getBean("MainDeployer", ControllerState.INSTALLED, MainDeployer.class);
                this.deployDeployDirectory();
                this.deployMain("ejb3-interceptors-aop.xml");
                this.deployModules(modules);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    public void close() {
        if (this.mainDeployer != null) {
            this.mainDeployer.prepareShutdown();
            this.mainDeployer.shutdown();
            this.mainDeployer = null;
        }
        if (this.server != null) {
            JBossEJBContainer.within(this.classLoader, new Runnable(){

                @Override
                public void run() {
                    try {
                        JBossEJBContainer.this.server.shutdown();
                    }
                    catch (Exception e) {
                        log.warn((Object)("Failed to shutdown server " + JBossEJBContainer.this.server), (Throwable)e);
                    }
                }
            });
        }
        this.kernel = null;
        ClassLoaderSystem.getInstance().unregisterClassLoader(this.classLoader);
    }

    private Deployment deploy(Deployment deployment) throws DeploymentException {
        log.info((Object)("Deploying " + deployment.getName()));
        this.mainDeployer.deploy(new Deployment[]{deployment});
        this.mainDeployer.checkComplete(new Deployment[]{deployment});
        return deployment;
    }

    public void deploy(Deployment ... deployments) throws DeploymentException, IOException {
        for (Deployment deployment : deployments) {
            this.deploy(deployment);
        }
    }

    public Deployment deploy(URL url) throws DeploymentException, IOException {
        VirtualFile root = VFS.getRoot((URL)url);
        VFSDeployment deployment = VFSDeploymentFactory.getInstance().createVFSDeployment(root);
        return this.deploy((Deployment)deployment);
    }

    protected void deployDeployDirectory() throws DeploymentException, IOException {
        URL deployDirURL = this.classLoader.getResource("deploy");
        if (deployDirURL == null) {
            log.warn((Object)("Can't find a deploy directory resource on class loader " + this.classLoader));
            return;
        }
        ArrayList<VFSDeployment> deployments = new ArrayList<VFSDeployment>();
        VirtualFile deployDir = VFS.getRoot((URL)deployDirURL);
        for (VirtualFile child : deployDir.getChildren()) {
            VFSDeployment deployment = VFSDeploymentFactory.getInstance().createVFSDeployment(child);
            log.info((Object)("Deploying " + deployment.getName()));
            deployments.add(deployment);
        }
        this.mainDeployer.deploy(deployments.toArray(new Deployment[0]));
    }

    private void deployMain(String name) throws DeploymentException, IllegalArgumentException, MalformedURLException, IOException {
        URL url = this.getResource(name);
        this.deploy(url);
    }

    private void deployModules(String[] modules) throws MalformedURLException, IOException, DeploymentException {
        if (modules == null) {
            return;
        }
        for (String module : modules) {
            this.deploy(new URL(module));
        }
    }

    protected Object getBean(Object name, ControllerState state) throws IllegalStateException {
        KernelControllerContext context = this.getControllerContext(name, state);
        return context.getTarget();
    }

    protected <T> T getBean(Object name, ControllerState state, Class<T> expected) throws ClassCastException, IllegalStateException {
        if (expected == null) {
            throw new IllegalArgumentException("Null expected");
        }
        Object bean = this.getBean(name, state);
        return expected.cast(bean);
    }

    protected KernelControllerContext getControllerContext(Object name, ControllerState state) throws IllegalStateException {
        KernelController controller = this.kernel.getController();
        KernelControllerContext context = (KernelControllerContext)controller.getContext(name, state);
        if (context == null) {
            return this.handleNotFoundContext((Controller)controller, name, state);
        }
        return context;
    }

    private URL getResource(String name) throws IllegalArgumentException {
        URL url = this.classLoader.getResource(name);
        if (url == null) {
            throw new IllegalArgumentException("No resource named " + name + " found on " + this.classLoader);
        }
        return url;
    }

    protected KernelControllerContext handleNotFoundContext(Controller controller, Object name, ControllerState state) throws IllegalStateException {
        throw new IllegalStateException("Bean not found " + name + " at state " + state + " in controller " + controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void within(ClassLoader cl, Runnable task) {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            task.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }
}

