/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded.deployers;

import java.util.Collections;
import java.util.Set;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.DemandMetaData;
import org.jboss.beans.metadata.spi.DependencyMetaData;
import org.jboss.beans.metadata.spi.SupplyMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.MCDependencyPolicy;
import org.jboss.ejb3.embedded.deployment.EmbeddedDescriptorHandler;
import org.jboss.ejb3.javaee.JavaEEComponentHelper;
import org.jboss.ejb3.javaee.JavaEEModule;
import org.jboss.ejb3.javaee.SimpleJavaEEModule;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;

public class EjbComponentDeployer
extends AbstractSimpleRealDeployer<JBossEnterpriseBeanMetaData> {
    private Set<String> additionalContainerDependencies = Collections.emptySet();

    public EjbComponentDeployer() {
        super(JBossEnterpriseBeanMetaData.class);
        this.setComponentsOnly(true);
        this.addOutput(BeanMetaData.class);
    }

    protected void addDependencies(BeanMetaDataBuilder builder, DeploymentUnit unit, EJBContainer component) {
        for (String dependency : this.additionalContainerDependencies) {
            builder.addDependency((Object)dependency);
        }
        builder.addDependency((Object)("org.jboss.ejb3.deployment:" + unit.getParent().getSimpleName()));
        MCDependencyPolicy dependencyPolicy = (MCDependencyPolicy)component.getDependencyPolicy();
        for (DemandMetaData demand : dependencyPolicy.getDemands()) {
            builder.addDemand(demand.getDemand());
        }
        for (DependencyMetaData dependency : dependencyPolicy.getDependencies()) {
            builder.addDependency(dependency.getDependency());
        }
        for (SupplyMetaData supply : dependencyPolicy.getSupplies()) {
            builder.addSupply(supply.getSupply());
        }
    }

    public void deploy(DeploymentUnit unit, JBossEnterpriseBeanMetaData metaData) throws DeploymentException {
        EJBContainer component;
        this.log.info((Object)("Found " + metaData + " in " + unit));
        SimpleJavaEEModule module = new SimpleJavaEEModule(unit.getParent().getSimpleName());
        String ejbName = metaData.getEjbName();
        String componentName = JavaEEComponentHelper.createObjectName((JavaEEModule)module, (String)ejbName);
        Ejb3Deployment deployment = (Ejb3Deployment)unit.getAttachment(Ejb3Deployment.class);
        try {
            EmbeddedDescriptorHandler handler = new EmbeddedDescriptorHandler(deployment, metaData.getEjbJarMetaData());
            component = handler.createEJBContainer(metaData);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)componentName, (String)component.getClass().getName());
        builder.setConstructorValue((Object)component);
        this.addDependencies(builder, unit, component);
        DeploymentUnit parent = unit.getParent();
        assert (parent != null) : "parent should not be null of component " + unit;
        BeanMetaData bmd = builder.getBeanMetaData();
        this.log.debug((Object)("deploying bean: " + bmd.getName()));
        this.log.debug((Object)"  with dependencies:");
        for (DependencyMetaData dependency : EjbComponentDeployer.in(bmd.getDepends())) {
            this.log.debug((Object)("\t" + dependency.getDependency()));
        }
        this.log.debug((Object)"  and demands:");
        for (DemandMetaData dmd : EjbComponentDeployer.in(bmd.getDemands())) {
            this.log.debug((Object)("\t" + dmd.getDemand()));
        }
        this.log.debug((Object)"  and supplies:");
        for (SupplyMetaData smd : EjbComponentDeployer.in(bmd.getSupplies())) {
            this.log.debug((Object)("\t" + smd.getSupply()));
        }
        parent.addAttachment(BeanMetaData.class + ":" + componentName, (Object)bmd);
    }

    private static <T> Set<T> in(Set<T> c) {
        if (c != null) {
            return c;
        }
        return Collections.emptySet();
    }

    public void setAdditionalContainerDependencies(Set<String> s) {
        this.additionalContainerDependencies = s;
    }
}

