/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded.deployers;

import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployerWithInput;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.embedded.deployment.EjbDeployment;
import org.jboss.ejb3.embedded.deployment.EmbeddedEjb3DeploymentUnit;
import org.jboss.jpa.resolvers.PersistenceUnitDependencyResolver;
import org.jboss.kernel.Kernel;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;

public class EjbModuleDeployer
extends AbstractRealDeployerWithInput<JBossMetaData> {
    @Deprecated
    private Kernel kernel;
    private PersistenceUnitDependencyResolver persistenceUnitDependencyResolver;

    public EjbModuleDeployer() {
        this.setDeploymentVisitor(new EjbDeploymentVisitor());
        this.addOutput(JBossEnterpriseBeanMetaData.class);
        this.addOutput(BeanMetaData.class);
    }

    private static Ejb3Deployment createModule(DeploymentUnit unit, JBossMetaData metaData) {
        EmbeddedEjb3DeploymentUnit ejb3Unit = new EmbeddedEjb3DeploymentUnit(unit);
        DeploymentScope scope = null;
        return new EjbDeployment(unit, ejb3Unit, scope, metaData);
    }

    @Inject(bean="jboss.kernel:service=Kernel")
    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    @Inject
    public void setPersistenceUnitDependencyResolver(PersistenceUnitDependencyResolver resolver) {
        this.persistenceUnitDependencyResolver = resolver;
    }

    private class EjbDeploymentVisitor
    implements DeploymentVisitor<JBossMetaData> {
        private EjbDeploymentVisitor() {
        }

        public void deploy(DeploymentUnit unit, JBossMetaData metaData) throws DeploymentException {
            EjbModuleDeployer.this.log.info((Object)("Found " + metaData + " in " + unit));
            JBossMetaData realMetaData = (JBossMetaData)unit.getTransientManagedObjects().getAttachment(JBossMetaData.class);
            if (realMetaData != null && realMetaData != metaData) {
                metaData = realMetaData;
                EjbModuleDeployer.this.log.info((Object)("but it's really " + metaData));
            }
            if (metaData.getEnterpriseBeans() == null) {
                EjbModuleDeployer.this.log.warn((Object)(unit + " contains no beans"));
                return;
            }
            Ejb3Deployment module = EjbModuleDeployer.createModule(unit, metaData);
            module.setPersistenceUnitDependencyResolver(EjbModuleDeployer.this.persistenceUnitDependencyResolver);
            unit.addAttachment(Ejb3Deployment.class, (Object)module);
            String name = "org.jboss.ejb3.deployment:" + unit.getSimpleName();
            BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)module.getClass().getName());
            builder.setConstructorValue((Object)module);
            unit.addAttachment(BeanMetaData.class + ":" + name, (Object)builder.getBeanMetaData());
            for (JBossEnterpriseBeanMetaData bean : metaData.getEnterpriseBeans()) {
                DeploymentUnit component = unit.addComponent(bean.getEjbName());
                component.addAttachment(JBossEnterpriseBeanMetaData.class, (Object)bean);
            }
        }

        public Class<JBossMetaData> getVisitorType() {
            return JBossMetaData.class;
        }

        public void undeploy(DeploymentUnit unit, JBossMetaData metaData) {
            if (metaData.getEnterpriseBeans() == null) {
                return;
            }
            for (JBossEnterpriseBeanMetaData bean : metaData.getEnterpriseBeans()) {
                unit.removeComponent(bean.getEjbName());
            }
            unit.removeAttachment(Ejb3Deployment.class);
        }
    }
}

