/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded.deployment;

import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3AnnotationHandler;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.Ejb3DescriptorHandler;
import org.jboss.metadata.ejb.jboss.JBossConsumerBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossServiceBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

public class EmbeddedDescriptorHandler
extends Ejb3DescriptorHandler {
    public EmbeddedDescriptorHandler(Ejb3Deployment deployment, JBossMetaData metaData) {
        super(deployment, metaData);
        for (JBossEnterpriseBeanMetaData bean : metaData.getEnterpriseBeans()) {
            this.ejbNames.add(bean.getEjbName());
            this.ejbs.add(bean);
        }
    }

    public EJBContainer createEJBContainer(JBossEnterpriseBeanMetaData beanMetaData) throws Exception {
        EJBContainer container;
        int index = this.ejbNames.indexOf(beanMetaData.getEjbName());
        assert (index != -1) : "Can't find bean " + beanMetaData.getEjbName() + " in " + this.ejbNames;
        Ejb3AnnotationHandler.EJB_TYPE ejbType = this.getEjbType(beanMetaData);
        this.className = beanMetaData.getEjbClass();
        this.ejbClass = this.di.getClassLoader().loadClass(this.className);
        if (ejbType == Ejb3AnnotationHandler.EJB_TYPE.STATELESS) {
            container = this.getStatelessContainer(index, (JBossSessionBeanMetaData)beanMetaData);
        } else if (ejbType == Ejb3AnnotationHandler.EJB_TYPE.STATEFUL) {
            container = this.getStatefulContainer(index, (JBossSessionBeanMetaData)beanMetaData);
        } else if (ejbType == Ejb3AnnotationHandler.EJB_TYPE.MESSAGE_DRIVEN) {
            container = this.getMDB(index, (JBossMessageDrivenBeanMetaData)beanMetaData);
        } else if (ejbType == Ejb3AnnotationHandler.EJB_TYPE.SERVICE) {
            container = this.getServiceContainer(index, (JBossServiceBeanMetaData)beanMetaData);
        } else if (ejbType == Ejb3AnnotationHandler.EJB_TYPE.CONSUMER) {
            container = this.getConsumerContainer(index, (JBossConsumerBeanMetaData)beanMetaData);
        } else {
            throw new UnsupportedOperationException("Can't create a container for type " + ejbType);
        }
        container.setJaccContextId(this.getJaccContextId());
        container.instantiated();
        container.processMetadata();
        return container;
    }
}

