/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded.dsl;

import java.io.IOException;
import java.net.URL;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.ejb3.embedded.dsl.Attachment;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

public class DeploymentBuilder {
    public static <T> Deployment deployment(String name, Attachment<?> ... attachments) {
        try {
            URL url = new URL("vfsmemory", name, "");
            return DeploymentBuilder.deployment(url, attachments);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Deployment deployment(String name, Class<T> attachmentType, T attachment) {
        try {
            URL url = new URL("vfsmemory", name, "");
            VirtualFile root = VFS.getRoot((URL)url);
            VFSDeployment deployment = VFSDeploymentFactory.getInstance().createVFSDeployment(root);
            MutableAttachments attachments = (MutableAttachments)deployment.getPredeterminedManagedObjects();
            attachments.addAttachment(attachmentType, attachment);
            return deployment;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Deployment deployment(URL url) throws IOException {
        VirtualFile root = VFS.getRoot((URL)url);
        VFSDeployment deployment = VFSDeploymentFactory.getInstance().createVFSDeployment(root);
        return deployment;
    }

    public static Deployment deployment(URL url, Attachment<?> ... attachments) throws IOException {
        VirtualFile root = VFS.getRoot((URL)url);
        VFSDeployment deployment = VFSDeploymentFactory.getInstance().createVFSDeployment(root);
        MutableAttachments managedObjects = (MutableAttachments)deployment.getPredeterminedManagedObjects();
        for (Attachment<?> attachment : attachments) {
            DeploymentBuilder.processAttachment(managedObjects, attachment);
        }
        return deployment;
    }

    private static <T> void processAttachment(MutableAttachments managedObjects, Attachment<T> attachment) {
        managedObjects.addAttachment(attachment.getAttachmentType(), attachment.getAttachment());
    }
}

