/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.metrics.deployer;

import javax.ejb.TimerService;
import org.jboss.ejb3.mdb.MessagingContainer;
import org.jboss.ejb3.mdb.MessagingDelegateWrapperMBean;
import org.jboss.ejb3.metrics.deployer.InvocationStatisticMetaMapper;
import org.jboss.ejb3.statistics.InvocationStatistics;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.metatype.api.annotations.MetaMapping;

@ManagementObject(isRuntime=true, properties=ManagementProperties.EXPLICIT, description="Message-Driven Instance Metrics", componentType=@ManagementComponent(type="EJB3", subtype="MessageDriven"))
public class BasicMessageDrivenMetrics
implements MessagingDelegateWrapperMBean {
    private MessagingContainer mdb;

    public BasicMessageDrivenMetrics(MessagingContainer mdb) throws IllegalArgumentException {
        if (mdb == null) {
            throw new IllegalArgumentException("Underlying container was null");
        }
        this.setMessagingContainer(mdb);
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC})
    public String getName() {
        return this.getMessagingContainer().getEjbName();
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC}, description="The number of milliseconds the instance will keep-alive")
    public int getKeepAliveMillis() {
        return this.getMBean().getKeepAliveMillis();
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC}, description="The maximum number of messages")
    public int getMaxMessages() {
        return this.getMBean().getMaxMessages();
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC}, description="The maximum number of backing objects allowed in the instance pool")
    public int getMaxPoolSize() {
        return this.getMBean().getMaxPoolSize();
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC}, description="The minimum number of backing objects allowed in the instance pool")
    public int getMinPoolSize() {
        return this.getMBean().getMinPoolSize();
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC}, description="If active delivery is enabled")
    public boolean isDeliveryActive() {
        return this.getMBean().isDeliveryActive();
    }

    @ManagementOperation(description="Starts delivery to the MDB")
    public void startDelivery() {
        this.getMBean().startDelivery();
    }

    @ManagementOperation(description="Stops delivery to the MDB")
    public void stopDelivery() {
        this.getMBean().stopDelivery();
    }

    @ManagementProperty(readOnly=true, use={ViewUse.STATISTIC}, description="Obtains the invocation statistics for this MDB", name="invocationStats")
    @MetaMapping(value=InvocationStatisticMetaMapper.class)
    public InvocationStatistics getInvokeStats() {
        return this.getMBean().getInvokeStats();
    }

    @ManagementOperation
    public void resetInvocationStats() {
        this.getMBean().getInvokeStats().resetStats();
    }

    public TimerService getTimerService(Object key) {
        throw new UnsupportedOperationException("Not supported via Managed Object; invoke over JMX Bus");
    }

    private MessagingDelegateWrapperMBean getMBean() {
        return (MessagingDelegateWrapperMBean)this.getMessagingContainer().getMBean();
    }

    private MessagingContainer getMessagingContainer() {
        return this.mdb;
    }

    private void setMessagingContainer(MessagingContainer mdb) {
        this.mdb = mdb;
    }
}

