/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.packagemanager;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PackageManagerEnvironment {
    private File packageManagerHome;
    private File packageManagerBuildDir;
    private File packageManagerTmpDir;
    private File packageManagerScriptStoreDir;
    private File packageManagerDataDir;
    private Map<String, String> properties = new HashMap<String, String>();

    public PackageManagerEnvironment(String home) {
        this(home, new HashMap<String, String>());
    }

    public PackageManagerEnvironment(String home, Map<String, String> props) {
        this.packageManagerHome = new File(home);
        HashMap hashMap = this.properties = props == null ? new HashMap() : props;
        if (!this.packageManagerHome.exists() || !this.packageManagerHome.isDirectory()) {
            throw new RuntimeException("Package manager home " + home + " doesn't exist or is not a directory");
        }
        this.initEnvironment();
    }

    private void initEnvironment() {
        this.packageManagerBuildDir = new File(this.packageManagerHome, "build");
        if (!this.packageManagerBuildDir.exists()) {
            this.packageManagerBuildDir.mkdirs();
        }
        this.packageManagerTmpDir = new File(this.packageManagerHome, "tmp");
        if (!this.packageManagerTmpDir.exists()) {
            this.packageManagerTmpDir.mkdirs();
        }
        this.packageManagerDataDir = new File(this.packageManagerHome, "data");
        if (!this.packageManagerDataDir.exists()) {
            this.packageManagerDataDir.mkdirs();
        }
        this.packageManagerScriptStoreDir = new File(this.packageManagerDataDir, "scripts");
        if (!this.packageManagerScriptStoreDir.exists()) {
            this.packageManagerScriptStoreDir.mkdirs();
        }
    }

    public File getPackageManagerHome() {
        return this.packageManagerHome;
    }

    public File getPackageManagerBuildDir() {
        return this.packageManagerBuildDir;
    }

    public File getPackageManagerTmpDir() {
        return this.packageManagerTmpDir;
    }

    public File getDataDir() {
        return this.packageManagerDataDir;
    }

    public File getScriptStoreDir() {
        return this.packageManagerScriptStoreDir;
    }

    public String getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public void setProperty(String propertyName, String propertyValue) {
        this.properties.put(propertyName, propertyValue);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }
}

