/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.packagemanager.main;

import jargs.gnu.CmdLineParser;
import java.io.File;
import java.util.Set;
import org.jboss.ejb3.packagemanager.PackageManager;
import org.jboss.ejb3.packagemanager.PackageManagerEnvironment;
import org.jboss.ejb3.packagemanager.PackageManagerFactory;
import org.jboss.ejb3.packagemanager.exception.PackageManagerException;
import org.jboss.logging.Logger;

public class Main {
    private static Logger logger = Logger.getLogger(Main.class);

    public static void main(String[] args) throws PackageManagerException {
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option installCmdOption = cmdLineParser.addStringOption('i', "install");
        CmdLineParser.Option upgradeCmdOption = cmdLineParser.addStringOption('u', "upgrade");
        CmdLineParser.Option removeCmdOption = cmdLineParser.addStringOption('r', "remove");
        CmdLineParser.Option queryCmdOption = cmdLineParser.addBooleanOption('q', "query");
        CmdLineParser.Option packageManagerHomeCmdOption = cmdLineParser.addStringOption('p', "pmhome");
        CmdLineParser.Option jbossHomeCmdOption = cmdLineParser.addStringOption('s', "jbossHome");
        try {
            cmdLineParser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println("Error parsing command " + e.getMessage());
            Main.printUsage();
            throw new PackageManagerException(e.getMessage());
        }
        File currentDir = new File(".");
        String packageManagerHomeEnvVariableValue = System.getProperty("PACKAGE_MANAGER_HOME", currentDir.getAbsolutePath());
        String packageManagerHome = (String)cmdLineParser.getOptionValue(packageManagerHomeCmdOption, (Object)packageManagerHomeEnvVariableValue);
        if (packageManagerHome == null) {
            throw new PackageManagerException("Package manager home has not been set");
        }
        File pmHome = new File(packageManagerHome);
        if (!pmHome.exists()) {
            throw new PackageManagerException("Package manager home " + pmHome + " does not exist!");
        }
        logger.info((Object)("Using Package Manager Home: " + packageManagerHome));
        PackageManagerEnvironment env = new PackageManagerEnvironment(packageManagerHome);
        String jbossHome = (String)cmdLineParser.getOptionValue(jbossHomeCmdOption);
        if (packageManagerHome == null) {
            throw new PackageManagerException("Package manager home has not been set");
        }
        if (jbossHome == null) {
            throw new PackageManagerException("JBoss Home has not been set");
        }
        File jbHome = new File(jbossHome);
        if (!jbHome.exists()) {
            throw new PackageManagerException("JBoss home " + jbHome + " does not exist!");
        }
        logger.info((Object)("Using JBoss Home: " + jbossHome));
        PackageManager pm = PackageManagerFactory.getDefaultPackageManager(env, jbossHome);
        Boolean query = (Boolean)cmdLineParser.getOptionValue(queryCmdOption, (Object)Boolean.FALSE);
        String packageToInstall = (String)cmdLineParser.getOptionValue(installCmdOption);
        String packageToUpgrade = (String)cmdLineParser.getOptionValue(upgradeCmdOption);
        String packageToRemove = (String)cmdLineParser.getOptionValue(removeCmdOption);
        if (query.booleanValue()) {
            Set<String> installedPackages = pm.getAllInstalledPackages();
            if (installedPackages.isEmpty()) {
                logger.info((Object)"There are no packages installed in the system");
            } else {
                logger.info((Object)"Following packages have been installed in the system: ");
                logger.info((Object)"----------------------------------------------------");
                for (String packageName : installedPackages) {
                    logger.info((Object)packageName);
                }
                logger.info((Object)"----------------------------------------------------");
            }
        }
        if (packageToInstall != null) {
            pm.installPackage(packageToInstall);
        }
        if (packageToUpgrade != null) {
            pm.updatePackage(packageToUpgrade);
        }
        if (packageToRemove != null) {
            pm.removePackage(packageToRemove);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: packagemanager [-i path_to_package] [-r package_name] [-u path_to_package] [-q] [-p path_to_package_manager_home]\n [-s path_to_jboss_home]");
    }
}

