/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.coordinator;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.Reapable;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.coordinator.TxStats;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.internal.arjuna.coordinator.ReaperElement;
import com.arjuna.ats.internal.arjuna.coordinator.ReaperThread;
import com.arjuna.ats.internal.arjuna.coordinator.ReaperWorkerThread;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;

public class TransactionReaper {
    public static final String NORMAL = "NORMAL";
    public static final String DYNAMIC = "DYNAMIC";
    public static final long defaultCheckPeriod = 120000L;
    public static final long defaultCancelWaitPeriod = 500L;
    public static final long defaultCancelFailWaitPeriod = 500L;
    public static final int defaultZombieMax = 8;
    private SortedSet _transactions = Collections.synchronizedSortedSet(new TreeSet());
    private Map _timeouts = Collections.synchronizedMap(new HashMap());
    private List _workQueue = new LinkedList();
    private long _checkPeriod = 0L;
    private long _cancelWaitPeriod = 0L;
    private long _cancelFailWaitPeriod = 0L;
    private int _zombieMax = 0;
    private static TransactionReaper _theReaper = null;
    private static ReaperThread _reaperThread = null;
    private static ReaperWorkerThread _reaperWorkerThread = null;
    private static boolean _dynamic = false;
    private static long _lifetime = 0L;
    private static int _zombieCount = 0;

    public TransactionReaper(long checkPeriod) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 4L, 1L, "TransactionReaper::TransactionReaper ( " + checkPeriod + " )");
        }
        this._checkPeriod = checkPeriod;
        if (this._transactions == null) {
            if (tsLogger.arjLoggerI18N.isFatalEnabled()) {
                tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.arjuna.coordinator.TransactionReaper_1");
            }
            throw new OutOfMemoryError();
        }
    }

    public void finalize() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(2L, 4L, 1L, "TransactionReaper.finalize ()");
        }
        this._transactions = null;
    }

    public final long checkingPeriod() {
        if (_dynamic) {
            try {
                ReaperElement head = (ReaperElement)this._transactions.first();
                return head._absoluteTimeout - System.currentTimeMillis();
            }
            catch (NoSuchElementException nsee) {
                return Long.MAX_VALUE;
            }
        }
        try {
            long waitTime;
            ReaperElement head = (ReaperElement)this._transactions.first();
            if (head._status != 0 && (waitTime = head._absoluteTimeout - System.currentTimeMillis()) < this._checkPeriod) {
                return head._absoluteTimeout - System.currentTimeMillis();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this._checkPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean check() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::check ()");
        }
        while (true) {
            long now;
            ReaperElement e;
            try {
                e = (ReaperElement)this._transactions.first();
            }
            catch (NoSuchElementException nsee) {
                return true;
            }
            if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.TransactionReaper_2", new Object[]{Long.toString(e._absoluteTimeout)});
            }
            if ((now = System.currentTimeMillis()) < e._absoluteTimeout) break;
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_18", new Object[]{e._control.get_uid(), e.statusName()});
            }
            ReaperElement reaperElement = e;
            synchronized (reaperElement) {
                switch (e._status) {
                    case 0: {
                        e._status = 1;
                        Object object = this;
                        synchronized (object) {
                            this._transactions.remove(e);
                            e._absoluteTimeout = System.currentTimeMillis() + this._cancelWaitPeriod;
                            this._transactions.add(e);
                        }
                        if (tsLogger.arjLogger.debugAllowed()) {
                            tsLogger.arjLogger.debug(16L, 4L, 1L, "Reaper scheduling TX for cancellation " + e._control.get_uid());
                        }
                        object = this._workQueue;
                        synchronized (object) {
                            this._workQueue.add(e);
                            this._workQueue.notify();
                            break;
                        }
                    }
                    case 1: {
                        Object object = this;
                        synchronized (object) {
                            this._transactions.remove(e);
                            e._absoluteTimeout = System.currentTimeMillis() + this._cancelWaitPeriod;
                            this._transactions.add(e);
                        }
                        if (!tsLogger.arjLogger.debugAllowed()) break;
                        tsLogger.arjLogger.debug(16L, 4L, 1L, "Reaper deferring interrupt for TX scheduled for cancel " + e._control.get_uid());
                        break;
                    }
                    case 2: {
                        e._status = 3;
                        e._worker.interrupt();
                        Object object = this;
                        synchronized (object) {
                            this._transactions.remove(e);
                            e._absoluteTimeout = System.currentTimeMillis() + this._cancelFailWaitPeriod;
                            this._transactions.add(e);
                        }
                        if (!tsLogger.arjLoggerI18N.isDebugEnabled()) break;
                        tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.TransactionReaper_4", new Object[]{e._control.get_uid()});
                        break;
                    }
                    case 3: {
                        e._status = 6;
                        Object object = this;
                        synchronized (object) {
                            ++_zombieCount;
                            if (tsLogger.arjLogger.isDebugEnabled()) {
                                tsLogger.arjLogger.debug(16L, 4L, 1L, "Reaper " + Thread.currentThread() + " got a zombie " + e._worker + " (zombie count now " + _zombieCount + ") cancelling " + e._control.get_uid());
                            }
                            if (_zombieCount == this._zombieMax && tsLogger.arjLoggerI18N.isErrorEnabled()) {
                                tsLogger.arjLoggerI18N.error("com.arjuna.ats.arjuna.coordinator.TransactionReaper_5", new Object[]{new Integer(_zombieCount)});
                            }
                        }
                        _reaperWorkerThread = new ReaperWorkerThread(_theReaper);
                        _reaperWorkerThread.setDaemon(true);
                        _reaperWorkerThread.start();
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_6", new Object[]{e._worker, e._control.get_uid()});
                        }
                        object = this;
                        synchronized (object) {
                            this._timeouts.remove(e._control);
                            this._transactions.remove(e);
                        }
                        try {
                            if (e._control.preventCommit()) {
                                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break;
                                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_10", new Object[]{e._control.get_uid()});
                                break;
                            }
                            if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break;
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_11", new Object[]{e._control.get_uid()});
                        }
                        catch (Exception e1) {
                            if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break;
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_12", new Object[]{e._control.get_uid()}, (Throwable)e1);
                        }
                        break;
                    }
                    case 4: 
                    case 5: {
                        Object object = this;
                        synchronized (object) {
                            this._timeouts.remove(e._control);
                            this._transactions.remove(e);
                            break;
                        }
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForCancellations() {
        List list2 = this._workQueue;
        synchronized (list2) {
            try {
                while (this._workQueue.isEmpty()) {
                    this._workQueue.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doCancellations() {
        while (true) {
            ReaperElement e;
            List list2 = this._workQueue;
            synchronized (list2) {
                try {
                    e = (ReaperElement)this._workQueue.remove(0);
                }
                catch (IndexOutOfBoundsException ioobe) {
                    break;
                }
            }
            if (tsLogger.arjLogger.debugAllowed()) {
                tsLogger.arjLogger.debug(16L, 4L, 1L, "Reaper Worker " + Thread.currentThread() + " attempting to cancel " + e._control.get_uid());
            }
            boolean cancelled = false;
            Exception exception = null;
            ReaperElement reaperElement = e;
            synchronized (reaperElement) {
                e._worker = Thread.currentThread();
                e._status = 2;
                e.notify();
            }
            try {
                if (e._control.running() && e._control.cancel() == 4) {
                    cancelled = true;
                    if (TxControl.enableStatistics) {
                        TxStats.incrementTimeouts();
                    }
                }
            }
            catch (Exception e1) {
                exception = e1;
            }
            Object e1 = e;
            synchronized (e1) {
                if (e._status == 6) {
                    ReaperWorkerThread worker = (ReaperWorkerThread)Thread.currentThread();
                    worker.shutdown();
                    TransactionReaper transactionReaper = this;
                    synchronized (transactionReaper) {
                        --_zombieCount;
                    }
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_13", new Object[]{Thread.currentThread(), e._control.get_uid(), new Integer(_zombieCount)});
                    }
                    break;
                }
                if (cancelled && e._status == 3) {
                    cancelled = false;
                    e._status = 4;
                    e.notify();
                } else {
                    e._status = cancelled ? 5 : 4;
                    e.notify();
                }
            }
            if (cancelled) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_7", new Object[]{Thread.currentThread(), e._control.get_uid()});
                }
                e1 = this;
                synchronized (e1) {
                    this._timeouts.remove(e._control);
                    this._transactions.remove(e);
                }
            }
            if (exception != null) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_9", new Object[]{Thread.currentThread(), e._control.get_uid()}, (Throwable)exception);
                }
            } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_8", new Object[]{Thread.currentThread(), e._control.get_uid()});
            }
            e1 = this;
            synchronized (e1) {
                this._timeouts.remove(e._control);
                this._transactions.remove(e);
            }
            try {
                if (e._control.preventCommit()) {
                    if (!tsLogger.arjLoggerI18N.isWarnEnabled()) continue;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_14", new Object[]{Thread.currentThread(), e._control.get_uid()});
                    continue;
                }
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) continue;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_15", new Object[]{Thread.currentThread(), e._control.get_uid()});
            }
            catch (Exception e2) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) continue;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_16", new Object[]{Thread.currentThread(), e._control.get_uid()}, (Throwable)e2);
            }
        }
    }

    public final long numberOfTransactions() {
        return this._transactions.size();
    }

    public final long numberOfTimeouts() {
        return this._timeouts.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean insert(Reapable control, int timeout) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::insert ( " + control + ", " + timeout + " )");
        }
        if (timeout == 0) {
            return true;
        }
        if (this._timeouts.containsKey(control)) {
            return false;
        }
        ReaperElement e = new ReaperElement(control, timeout);
        TransactionReaper transactionReaper = this;
        synchronized (transactionReaper) {
            _lifetime += (long)timeout;
            this._timeouts.put(control, e);
            boolean rtn = this._transactions.add(e);
            if (_dynamic) {
                this.notify();
            }
            return rtn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(Object control) {
        ReaperElement key;
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::remove ( " + control + " )");
        }
        if (control == null) {
            return false;
        }
        Object object = this;
        synchronized (object) {
            key = (ReaperElement)this._timeouts.remove(control);
            if (key == null) {
                return false;
            }
        }
        object = key;
        synchronized (object) {
            if (key._status != 0) {
                return false;
            }
            TransactionReaper transactionReaper = this;
            synchronized (transactionReaper) {
                return this._transactions.remove(key);
            }
        }
    }

    public final long getRemainingTimeoutMills(Object control) {
        if (this._transactions.size() == 0 || control == null) {
            if (tsLogger.arjLogger.debugAllowed()) {
                tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::getRemainingTimeout for " + control + " returning 0");
            }
            return 0L;
        }
        ReaperElement reaperElement = (ReaperElement)this._timeouts.get(control);
        long timeout = 0L;
        timeout = reaperElement == null ? 0L : reaperElement._absoluteTimeout - System.currentTimeMillis();
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.TransactionReaper_17", new Object[]{control, timeout});
        }
        return timeout;
    }

    public final int getTimeout(Object control) {
        if (this._transactions.size() == 0 || control == null) {
            if (tsLogger.arjLogger.debugAllowed()) {
                tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::getTimeout for " + control + " returning 0");
            }
            return 0;
        }
        ReaperElement reaperElement = (ReaperElement)this._timeouts.get(control);
        Integer timeout = reaperElement == null ? new Integer(0) : new Integer(reaperElement._timeout);
        tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.TransactionReaper_3", new Object[]{control, timeout});
        return timeout;
    }

    public static synchronized TransactionReaper create(long checkPeriod) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::create ( " + checkPeriod + " )");
        }
        if (_theReaper == null) {
            String zombieMax;
            String cancelFailWait;
            String mode = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.txReaperMode");
            if (mode != null && mode.compareTo(DYNAMIC) == 0) {
                _dynamic = true;
            }
            if (!_dynamic) {
                String timeoutEnv = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.txReaperTimeout");
                if (timeoutEnv != null) {
                    Long l = null;
                    try {
                        l = new Long(timeoutEnv);
                        checkPeriod = l;
                        l = null;
                    }
                    catch (NumberFormatException e) {
                        if (tsLogger.arjLogger.isWarnEnabled()) {
                            tsLogger.arjLogger.warn("TransactionReaper::create - " + e);
                        }
                    }
                }
            } else {
                checkPeriod = Long.MAX_VALUE;
            }
            _theReaper = new TransactionReaper(checkPeriod);
            String cancelWait = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.txReaperCancelWaitPeriod");
            if (cancelWait != null) {
                try {
                    TransactionReaper._theReaper._cancelWaitPeriod = Long.valueOf(cancelWait);
                }
                catch (NumberFormatException e) {
                    TransactionReaper._theReaper._cancelWaitPeriod = 500L;
                }
                if (TransactionReaper._theReaper._cancelWaitPeriod < 10L) {
                    TransactionReaper._theReaper._cancelWaitPeriod = 10L;
                }
            } else {
                TransactionReaper._theReaper._cancelWaitPeriod = 500L;
            }
            if ((cancelFailWait = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.txReaperCancelFailWaitPeriod")) != null) {
                try {
                    TransactionReaper._theReaper._cancelFailWaitPeriod = Long.valueOf(cancelFailWait);
                }
                catch (NumberFormatException e) {
                    TransactionReaper._theReaper._cancelFailWaitPeriod = 500L;
                }
                if (TransactionReaper._theReaper._cancelFailWaitPeriod < 10L) {
                    TransactionReaper._theReaper._cancelFailWaitPeriod = 10L;
                }
            } else {
                TransactionReaper._theReaper._cancelFailWaitPeriod = 500L;
            }
            if ((zombieMax = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.txReaperZombieMax")) != null) {
                try {
                    TransactionReaper._theReaper._zombieMax = Integer.valueOf(zombieMax);
                }
                catch (NumberFormatException e) {
                    TransactionReaper._theReaper._zombieMax = 8;
                }
                if (TransactionReaper._theReaper._zombieMax <= 0) {
                    TransactionReaper._theReaper._zombieMax = 1;
                }
            } else {
                TransactionReaper._theReaper._zombieMax = 8;
            }
            TransactionReaper._theReaper._cancelWaitPeriod = 500L;
            TransactionReaper._theReaper._cancelFailWaitPeriod = 500L;
            TransactionReaper._theReaper._zombieMax = 8;
            _reaperThread = new ReaperThread(_theReaper);
            _reaperThread.setDaemon(true);
            _reaperWorkerThread = new ReaperWorkerThread(_theReaper);
            _reaperWorkerThread.setDaemon(true);
            _reaperThread.start();
            _reaperWorkerThread.start();
        }
        return _theReaper;
    }

    public static TransactionReaper create() {
        return TransactionReaper.create(120000L);
    }

    public static TransactionReaper transactionReaper() {
        return TransactionReaper.transactionReaper(false);
    }

    public static synchronized TransactionReaper transactionReaper(boolean createReaper) {
        if (createReaper) {
            return TransactionReaper.create();
        }
        return _theReaper;
    }

    public static final synchronized long transactionLifetime() {
        return _lifetime;
    }

    static final void reset() {
        _theReaper = null;
    }
}

