/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.resources;

import com.arjuna.ArjunaOTS.ArjunaSubtranAwareResource;
import com.arjuna.ArjunaOTS.ArjunaSubtranAwareResourceHelper;
import com.arjuna.ArjunaOTS.OTSAbstractRecord;
import com.arjuna.ArjunaOTS.OTSAbstractRecordHelper;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.orbspecific.ControlImple;
import com.arjuna.ats.internal.jts.orbspecific.coordinator.ArjunaTransactionImple;
import com.arjuna.ats.jts.CosTransactionsNames;
import com.arjuna.ats.jts.logging.jtsLogger;
import java.io.IOException;
import java.io.PrintWriter;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;

public class ExtendedResourceRecord
extends AbstractRecord {
    private Coordinator _parentCoordHandle;
    private ArjunaSubtranAwareResource _resourceHandle;
    private String _stringifiedResourceHandle;
    private Uid _recCoordUid;
    private ArjunaTransactionImple _currentTransaction;
    private boolean _propagateRecord;
    private Uid _cachedUid = null;
    private int _cachedType = -1;
    private int _doSave = -1;
    private boolean _rolledback;
    private boolean _endpointFailed;
    private boolean _restored;

    public ExtendedResourceRecord(boolean propagate, Uid objUid, ArjunaSubtranAwareResource theResource, Coordinator myParent, Uid recCoordUid, ArjunaTransactionImple current) {
        super(objUid, null, 1);
        this._resourceHandle = theResource;
        this._stringifiedResourceHandle = null;
        this._parentCoordHandle = myParent;
        this._recCoordUid = recCoordUid != null ? recCoordUid : new Uid(Uid.nullUid());
        this._currentTransaction = current;
        this._propagateRecord = propagate;
        this._rolledback = false;
        this._endpointFailed = false;
        this._restored = false;
    }

    public void finalize() throws Throwable {
        this._resourceHandle = null;
        this._stringifiedResourceHandle = null;
        this._recCoordUid = null;
        this._parentCoordHandle = null;
        this._currentTransaction = null;
        super.finalize();
    }

    public final ArjunaSubtranAwareResource resourceHandle() {
        block8: {
            if (this._resourceHandle == null && this._stringifiedResourceHandle != null) {
                try {
                    ORB theOrb = ORBManager.getORB().orb();
                    if (theOrb == null) {
                        throw new UNKNOWN();
                    }
                    if (jtsLogger.logger.isDebugEnabled()) {
                        jtsLogger.logger.debug(16L, 4L, 264L, "ExtendedResourceRecord: About to string_to_object on " + this._stringifiedResourceHandle);
                    }
                    Object optr = theOrb.string_to_object(this._stringifiedResourceHandle);
                    if (jtsLogger.logger.isDebugEnabled()) {
                        jtsLogger.logger.debug(16L, 4L, 264L, "ExtendedResourceRecord: Successfully stringed to object, next try to narrow");
                    }
                    theOrb = null;
                    this._resourceHandle = ArjunaSubtranAwareResourceHelper.narrow((Object)optr);
                    if (jtsLogger.logger.isDebugEnabled()) {
                        jtsLogger.logger.debug(16L, 4L, 264L, "ExtendedResourceRecord: Successfully narrowed");
                    }
                    if (this._resourceHandle == null) {
                        throw new BAD_PARAM();
                    }
                    java.lang.Object var2_3 = null;
                }
                catch (SystemException e) {
                    if (!jtsLogger.logger.isDebugEnabled()) break block8;
                    jtsLogger.logger.debug(16L, 4L, 264L, "ExtendedResourceRecord: Failed to narrow to ArjunaSubtranAwareResource");
                }
            }
        }
        return this._resourceHandle;
    }

    public boolean propagateOnCommit() {
        if (this._propagateRecord) {
            return true;
        }
        OTSAbstractRecord resHandle = this.otsRecord();
        try {
            if (resHandle != null && !this._endpointFailed) {
                return resHandle.propagateOnCommit();
            }
        }
        catch (Exception e) {
            this._endpointFailed = true;
        }
        return true;
    }

    public boolean propagateOnAbort() {
        OTSAbstractRecord resHandle = this.otsRecord();
        try {
            if (resHandle != null && !this._endpointFailed) {
                return resHandle.propagateOnAbort();
            }
        }
        catch (Exception e) {
            this._endpointFailed = true;
        }
        return false;
    }

    public Uid order() {
        Uid toReturn = super.order();
        if (this._cachedUid == null) {
            OTSAbstractRecord resHandle = this.otsRecord();
            try {
                if (resHandle != null && !this._endpointFailed) {
                    toReturn = this._cachedUid = new Uid(resHandle.uid());
                }
            }
            catch (Exception e) {
                this._endpointFailed = true;
            }
        } else {
            toReturn = this._cachedUid;
        }
        return toReturn;
    }

    public int typeIs() {
        int r;
        OTSAbstractRecord resHandle;
        block5: {
            resHandle = this.otsRecord();
            r = 151;
            if (this._cachedType == -1) {
                try {
                    if (resHandle != null && !this._endpointFailed) {
                        this._cachedType = r = resHandle.type_id();
                    }
                    break block5;
                }
                catch (Exception e) {
                    r = 151;
                    this._endpointFailed = true;
                    if (jtsLogger.loggerI18N.isWarnEnabled()) {
                        jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.resources.errtypefail", new java.lang.Object[]{"ExtendedResourceRecord.typeIs", new Integer(r)});
                    }
                    break block5;
                }
            }
            r = this._cachedType;
        }
        resHandle = null;
        return r;
    }

    public ClassName className() {
        return CosTransactionsNames.AbstractRecord_ExtendedResourceRecord();
    }

    public java.lang.Object value() {
        return this._resourceHandle;
    }

    public void setValue(java.lang.Object o) {
        if (jtsLogger.loggerI18N.isWarnEnabled()) {
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.resources.errsetvalue", new java.lang.Object[]{"ExtendedResourceRecord.set_value"});
        }
    }

    public int nestedAbort() {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 264L, "ExtendedResourceRecord::nestedAbort() for " + this.order());
        }
        try {
            this.resourceHandle().rollback_subtransaction();
        }
        catch (OBJECT_NOT_EXIST one) {
            if (this._rolledback) {
                this._rolledback = false;
                return 7;
            }
            return 8;
        }
        catch (SystemException ex) {
            return 8;
        }
        return 7;
    }

    public int nestedCommit() {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 264L, "ExtendedResourceRecord::nestedCommit() for " + this.order());
        }
        int o = 8;
        try {
            this.resourceHandle().commit_subtransaction(this._parentCoordHandle);
            this._parentCoordHandle = null;
            if (this._currentTransaction != null) {
                this._currentTransaction = (ArjunaTransactionImple)this._currentTransaction.parent();
                ControlImple control = this._currentTransaction.getControlHandle();
                if (control != null) {
                    this._parentCoordHandle = control.get_coordinator();
                    control = null;
                    o = 7;
                } else {
                    if (jtsLogger.loggerI18N.isWarnEnabled()) {
                        jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.resources.errnoparent", new java.lang.Object[]{"ExtendedResourceRecord.nestedCommit"});
                    }
                    o = 8;
                }
            } else {
                o = 8;
            }
        }
        catch (Exception e) {
            o = 8;
        }
        return o;
    }

    public int nestedPrepare() {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 264L, "ExtendedResourceRecord::nestedPrepare() for " + this.order());
        }
        int o = 1;
        try {
            switch (this.resourceHandle().prepare_subtransaction().value()) {
                case 0: {
                    o = 0;
                    break;
                }
                case 1: {
                    this._rolledback = true;
                    o = 1;
                    break;
                }
                case 2: {
                    o = 2;
                }
            }
        }
        catch (Exception e) {
            o = 1;
        }
        return o;
    }

    public int topLevelAbort() {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 264L, "ExtendedResourceRecord::topLevelAbort() for " + this.order());
        }
        try {
            if (this.resourceHandle() == null) {
                return 8;
            }
            this._resourceHandle.rollback();
        }
        catch (HeuristicCommit e1) {
            if (this._rolledback) {
                return 6;
            }
            return 4;
        }
        catch (HeuristicMixed e2) {
            return 5;
        }
        catch (HeuristicHazard e3) {
            return 6;
        }
        catch (OBJECT_NOT_EXIST one) {
            if (this._rolledback) {
                return 7;
            }
            return 6;
        }
        catch (SystemException e4) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.resources.errgenerr", new java.lang.Object[]{"ExtendedResourceRecord.topLevelAbort", e4});
            }
            return 8;
        }
        return 7;
    }

    public int topLevelCommit() {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 264L, "ExtendedResourceRecord::topLevelCommit() for " + this.order());
        }
        try {
            if (this.resourceHandle() == null) {
                return 8;
            }
            this._resourceHandle.commit();
        }
        catch (NotPrepared e1) {
            return 9;
        }
        catch (HeuristicRollback e2) {
            return 3;
        }
        catch (HeuristicMixed e3) {
            return 5;
        }
        catch (HeuristicHazard e4) {
            return 6;
        }
        catch (SystemException e5) {
            return 8;
        }
        return 7;
    }

    public int topLevelPrepare() {
        block11: {
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug(16L, 4L, 264L, "ExtendedResourceRecord::topLevelPrepare() for " + this.order());
            }
            try {
                if (this.resourceHandle() != null) {
                    switch (this._resourceHandle.prepare().value()) {
                        case 0: {
                            return 0;
                        }
                        case 1: {
                            this._rolledback = true;
                            return 1;
                        }
                        case 2: {
                            return 2;
                        }
                    }
                    break block11;
                }
                return 1;
            }
            catch (HeuristicMixed e1) {
                return 5;
            }
            catch (HeuristicHazard e2) {
                return 6;
            }
            catch (Exception e) {
                return 1;
            }
        }
        return 1;
    }

    public int nestedOnePhaseCommit() {
        switch (this.nestedPrepare()) {
            case 0: {
                return this.nestedCommit();
            }
            case 2: {
                return 7;
            }
        }
        return 8;
    }

    public int topLevelOnePhaseCommit() {
        try {
            if (this.resourceHandle() != null) {
                this._resourceHandle.commit_one_phase();
            }
        }
        catch (HeuristicHazard e1) {
            return 6;
        }
        catch (TRANSACTION_ROLLEDBACK e4) {
            return 8;
        }
        catch (INVALID_TRANSACTION e5) {
            return 8;
        }
        catch (Exception e5) {
            e5.printStackTrace();
            return 6;
        }
        return 7;
    }

    public boolean forgetHeuristic() {
        block4: {
            try {
                if (this.resourceHandle() != null) {
                    this._resourceHandle.forget();
                    return true;
                }
                if (jtsLogger.loggerI18N.isWarnEnabled()) {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.resources.errnores", new java.lang.Object[]{"ExtendedResourceRecord.forgetHeuristic"});
                }
            }
            catch (Exception e) {
                if (!jtsLogger.loggerI18N.isWarnEnabled()) break block4;
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.resources.errgenerr", new java.lang.Object[]{"ExtendedResourceRecord.forgetHeuristic", e});
            }
        }
        return false;
    }

    public static AbstractRecord create() {
        return new ExtendedResourceRecord();
    }

    public void remove(AbstractRecord toDelete) {
        toDelete = null;
    }

    public void print(PrintWriter strm) {
        super.print(strm);
        strm.println("ExtendedResourceRecord");
        strm.println(this._resourceHandle + "\t" + this._parentCoordHandle + "\t" + this._propagateRecord);
    }

    public boolean restore_state(InputObjectState os, int t) {
        int isString = 0;
        boolean result = super.restore_state(os, t);
        if (!result) {
            return false;
        }
        try {
            this._propagateRecord = os.unpackBoolean();
            this._parentCoordHandle = null;
            this._cachedUid = new Uid(Uid.nullUid());
            this._cachedUid.unpack(os);
            this._cachedType = os.unpackInt();
            isString = os.unpackInt();
            if (isString == 1) {
                this._stringifiedResourceHandle = os.unpackString();
                this._recCoordUid.unpack(os);
                if (jtsLogger.logger.isDebugEnabled()) {
                    jtsLogger.logger.debug(16L, 4L, 264L, "ExtendedResourceRecord.restore_state: unpacked record with uid=" + this._recCoordUid);
                }
            } else {
                this._stringifiedResourceHandle = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            result = false;
        }
        this._restored = result;
        return result;
    }

    public boolean save_state(OutputObjectState os, int t) {
        boolean result = super.save_state(os, t);
        if (!result) {
            return false;
        }
        try {
            os.packBoolean(this._propagateRecord);
            if (this._cachedUid == null) {
                this._cachedUid = this.order();
            }
            this._cachedUid.pack(os);
            if (this._cachedType == -1) {
                this._cachedType = this.typeIs();
            }
            os.packInt(this._cachedType);
            if (this._resourceHandle == null && this._stringifiedResourceHandle == null) {
                os.packInt(-1);
            } else {
                os.packInt(1);
                String stringRef = null;
                if (this._resourceHandle != null) {
                    ORB theOrb = ORBManager.getORB().orb();
                    if (theOrb == null) {
                        throw new UNKNOWN();
                    }
                    stringRef = theOrb.object_to_string((Object)this._resourceHandle);
                    theOrb = null;
                } else {
                    stringRef = this._stringifiedResourceHandle;
                }
                if (stringRef != null) {
                    os.packString(stringRef);
                    if (jtsLogger.logger.isDebugEnabled()) {
                        jtsLogger.logger.debug(16L, 4L, 264L, "ExtendedResourceRecord: packed obj ref " + stringRef);
                    }
                } else {
                    result = false;
                }
                stringRef = null;
                if (result) {
                    this._recCoordUid.pack(os);
                    if (jtsLogger.logger.isDebugEnabled()) {
                        jtsLogger.logger.debug(16L, 4L, 264L, "Packed rec co uid of " + this._recCoordUid);
                    }
                }
            }
        }
        catch (IOException e) {
            result = false;
        }
        catch (SystemException e) {
            result = false;
        }
        return result;
    }

    public String type() {
        return "/StateManager/AbstractRecord/ExtendedResourceRecord";
    }

    public boolean doSave() {
        boolean save;
        OTSAbstractRecord resHandle;
        block9: {
            if (this._restored) {
                return true;
            }
            switch (this._doSave) {
                case -1: {
                    break;
                }
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            resHandle = this.otsRecord();
            save = true;
            try {
                if (resHandle != null && !this._endpointFailed) {
                    save = resHandle.saveRecord();
                }
            }
            catch (Exception e) {
                save = true;
                this._endpointFailed = true;
                if (!jtsLogger.loggerI18N.isWarnEnabled()) break block9;
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.resources.errsavefail", new java.lang.Object[]{"ExtendedResourceRecord.doSave", new Boolean(save)});
            }
        }
        resHandle = null;
        this._doSave = save ? 1 : 0;
        return save;
    }

    public final Uid getRCUid() {
        return this._recCoordUid;
    }

    public void merge(AbstractRecord absRec) {
        OTSAbstractRecord rec;
        OTSAbstractRecord resHandle = this.otsRecord();
        if (resHandle != null && (rec = this.otsRecord(absRec)) != null) {
            block4: {
                try {
                    resHandle.merge(rec);
                }
                catch (OBJECT_NOT_EXIST ex) {
                }
                catch (Exception e) {
                    if (!jtsLogger.loggerI18N.isWarnEnabled()) break block4;
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.resources.errgenerr", new java.lang.Object[]{"ExtendedResourceRecord.merge", e});
                }
            }
            java.lang.Object var3_3 = null;
        }
        resHandle = null;
    }

    public void alter(AbstractRecord absRec) {
        OTSAbstractRecord rec;
        OTSAbstractRecord resHandle = this.otsRecord();
        if (resHandle != null && (rec = this.otsRecord(absRec)) != null) {
            block4: {
                try {
                    resHandle.alter(rec);
                }
                catch (OBJECT_NOT_EXIST ex) {
                }
                catch (Exception e) {
                    if (!jtsLogger.loggerI18N.isWarnEnabled()) break block4;
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.resources.errgenerr", new java.lang.Object[]{"ExtendedResourceRecord.alter", e});
                }
            }
            java.lang.Object var3_3 = null;
        }
        resHandle = null;
    }

    public boolean shouldAdd(AbstractRecord absRec) {
        OTSAbstractRecord rec;
        boolean result = false;
        OTSAbstractRecord resHandle = this.otsRecord();
        if (resHandle != null && !this._endpointFailed && (rec = this.otsRecord(absRec)) != null) {
            block4: {
                try {
                    result = resHandle.shouldAdd(rec);
                }
                catch (OBJECT_NOT_EXIST ex) {
                }
                catch (Exception e) {
                    this._endpointFailed = true;
                    if (!jtsLogger.loggerI18N.isWarnEnabled()) break block4;
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.resources.errgenerr", new java.lang.Object[]{"ExtendedResourceRecord.shouldAdd", e});
                }
            }
            rec = null;
        }
        resHandle = null;
        return result;
    }

    public boolean shouldAlter(AbstractRecord absRec) {
        OTSAbstractRecord rec;
        boolean result = false;
        OTSAbstractRecord resHandle = this.otsRecord();
        if (resHandle != null && !this._endpointFailed && (rec = this.otsRecord(absRec)) != null) {
            block4: {
                try {
                    result = resHandle.shouldAlter(rec);
                }
                catch (OBJECT_NOT_EXIST ex) {
                }
                catch (Exception e) {
                    this._endpointFailed = true;
                    if (!jtsLogger.loggerI18N.isWarnEnabled()) break block4;
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.resources.errgenerr", new java.lang.Object[]{"ExtendedResourceRecord.shouldAlter", e});
                }
            }
            rec = null;
        }
        resHandle = null;
        return result;
    }

    public boolean shouldMerge(AbstractRecord absRec) {
        OTSAbstractRecord rec;
        boolean result = false;
        OTSAbstractRecord resHandle = this.otsRecord();
        if (resHandle != null && !this._endpointFailed && (rec = this.otsRecord(absRec)) != null) {
            block4: {
                try {
                    result = resHandle.shouldMerge(rec);
                }
                catch (OBJECT_NOT_EXIST ex) {
                }
                catch (Exception e) {
                    this._endpointFailed = true;
                    if (!jtsLogger.loggerI18N.isWarnEnabled()) break block4;
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.resources.errgenerr", new java.lang.Object[]{"ExtendedResourceRecord.shouldMerge", e});
                }
            }
            rec = null;
        }
        resHandle = null;
        return result;
    }

    public boolean shouldReplace(AbstractRecord absRec) {
        OTSAbstractRecord rec;
        boolean result = this.recoveryReplace(absRec);
        OTSAbstractRecord resHandle = this.otsRecord();
        if (resHandle != null && !result && !this._endpointFailed && (rec = this.otsRecord(absRec)) != null) {
            block4: {
                try {
                    result = resHandle.shouldReplace(rec);
                }
                catch (OBJECT_NOT_EXIST ex) {
                }
                catch (Exception e) {
                    this._endpointFailed = true;
                    if (!jtsLogger.loggerI18N.isWarnEnabled()) break block4;
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.resources.errgenerr", new java.lang.Object[]{"ExtendedResourceRecord.shouldReplace", e});
                }
            }
            rec = null;
        }
        resHandle = null;
        return result;
    }

    protected ExtendedResourceRecord() {
        this._resourceHandle = null;
        this._stringifiedResourceHandle = null;
        this._recCoordUid = new Uid(Uid.nullUid());
        this._parentCoordHandle = null;
        this._currentTransaction = null;
        this._propagateRecord = false;
        this._endpointFailed = false;
        this._restored = false;
    }

    private boolean recoveryReplace(AbstractRecord rec) {
        boolean replace = false;
        if (rec != null && rec instanceof ExtendedResourceRecord) {
            ExtendedResourceRecord newRec = (ExtendedResourceRecord)rec;
            if (this._recCoordUid.notEquals(Uid.nullUid()) && this._recCoordUid.equals(newRec.getRCUid())) {
                replace = true;
            }
        }
        return replace;
    }

    private final OTSAbstractRecord otsRecord(AbstractRecord absRec) {
        OTSAbstractRecord resHandle;
        block3: {
            resHandle = null;
            if (absRec != null && absRec instanceof ExtendedResourceRecord) {
                try {
                    ExtendedResourceRecord theRecord = (ExtendedResourceRecord)absRec;
                    ArjunaSubtranAwareResource theResource = theRecord.resourceHandle();
                    resHandle = OTSAbstractRecordHelper.narrow((Object)theResource);
                    theResource = null;
                }
                catch (Exception e) {
                    if (!jtsLogger.loggerI18N.isWarnEnabled()) break block3;
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.resources.errgenerr", new java.lang.Object[]{"ExtendedResourceRecord.otsRecord", e});
                }
            }
        }
        return resHandle;
    }

    private final OTSAbstractRecord otsRecord() {
        try {
            OTSAbstractRecord otsARHandle = OTSAbstractRecordHelper.narrow((Object)this._resourceHandle);
            if (otsARHandle == null) {
                throw new BAD_PARAM();
            }
            return otsARHandle;
        }
        catch (Exception e) {
            return null;
        }
    }
}

