/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.packagemanager.db;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.transaction.Synchronization;
import org.jboss.ejb3.packagemanager.PackageContext;
import org.jboss.ejb3.packagemanager.PackageManagerContext;
import org.jboss.ejb3.packagemanager.PackageManagerEnvironment;
import org.jboss.ejb3.packagemanager.db.PackageDatabaseManager;
import org.jboss.ejb3.packagemanager.entity.PersistentDependency;
import org.jboss.ejb3.packagemanager.entity.PersistentFile;
import org.jboss.ejb3.packagemanager.entity.PersistentPackage;
import org.jboss.ejb3.packagemanager.entity.PersistentPackageManager;
import org.jboss.ejb3.packagemanager.entity.PersistentPostUnInstallScript;
import org.jboss.ejb3.packagemanager.entity.PersistentPreUnInstallScript;
import org.jboss.ejb3.packagemanager.exception.PackageManagerException;
import org.jboss.ejb3.packagemanager.exception.PackageNotInstalledException;
import org.jboss.ejb3.packagemanager.metadata.InstallFileType;
import org.jboss.ejb3.packagemanager.metadata.ScriptType;
import org.jboss.logging.Logger;

public class DefaultDatabaseManager
implements PackageDatabaseManager,
Synchronization {
    private static Logger logger = Logger.getLogger(DefaultDatabaseManager.class);
    private EntityManagerFactory entityMgrFactory;
    private ThreadLocal<EntityManager> currentEntityManager = new ThreadLocal();
    private PackageManagerContext packageManagerCtx;

    public DefaultDatabaseManager(PackageManagerContext pkgMgrCtx) {
        this.packageManagerCtx = pkgMgrCtx;
        PackageManagerEnvironment environment = pkgMgrCtx.getPackageManagerEnvironment();
        File dbHome = environment.getDataDir();
        System.setProperty("derby.system.home", dbHome.getAbsolutePath());
        logger.info((Object)("Package manager DB home set to " + System.getProperty("derby.system.home")));
        this.entityMgrFactory = Persistence.createEntityManagerFactory((String)"default");
    }

    private PersistentPackageManager getOrCreatePackageManagerEntity(PackageManagerContext pkgMgrCtx) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("from " + PersistentPackageManager.class.getSimpleName() + " pm where pm.jbossHome='" + pkgMgrCtx.getJBossServerHome() + "'");
        List packageManagers = query.getResultList();
        if (packageManagers == null || packageManagers.isEmpty()) {
            PersistentPackageManager pm = new PersistentPackageManager(pkgMgrCtx);
            em.persist((Object)pm);
            return pm;
        }
        if (packageManagers.size() > 1) {
            throw new RuntimeException("More than one package manager found for JBOSS_HOME " + pkgMgrCtx.getJBossServerHome());
        }
        return (PersistentPackageManager)packageManagers.get(0);
    }

    @Override
    public PersistentPackage installPackage(PackageContext pkgCtx) {
        PersistentPackage newlyInstalledPackage;
        EntityManager em = this.getEntityManager();
        PersistentPackageManager packageManager = this.getOrCreatePackageManagerEntity(this.packageManagerCtx);
        try {
            newlyInstalledPackage = this.createPackage(packageManager, pkgCtx);
        }
        catch (PackageManagerException pme) {
            throw new RuntimeException(pme);
        }
        em.persist((Object)newlyInstalledPackage);
        logger.info((Object)("Recorded installation of package " + pkgCtx + " to database"));
        return newlyInstalledPackage;
    }

    @Override
    public PersistentPackage getInstalledPackage(String name) throws PackageNotInstalledException {
        EntityManager em = this.getEntityManager();
        PersistentPackageManager packageManager = this.getOrCreatePackageManagerEntity(this.packageManagerCtx);
        Query query = em.createQuery("from " + PersistentPackage.class.getSimpleName() + " p where p.name='" + name + "' and p.packageManager.id=" + packageManager.getId());
        return (PersistentPackage)query.getSingleResult();
    }

    @Override
    public boolean isPackageInstalled(String name) {
        EntityManager em = this.getEntityManager();
        PersistentPackageManager packageManager = this.getOrCreatePackageManagerEntity(this.packageManagerCtx);
        Query query = em.createQuery("from " + PersistentPackage.class.getSimpleName() + " p where p.name='" + name + "' and p.packageManager.id=" + packageManager.getId());
        List result = query.getResultList();
        return result != null && !result.isEmpty();
    }

    @Override
    public Set<PersistentPackage> getDependentPackages(String name) throws PackageNotInstalledException {
        PersistentPackage installedPackage = this.getInstalledPackage(name);
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("select pd.dependentPackage from " + PersistentDependency.class.getSimpleName() + " pd " + "join pd.dependeePackage p " + " where p.name='" + installedPackage.getPackageName() + "'");
        List result = query.getResultList();
        if (result == null || result.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<PersistentPackage> dependentPackages = new HashSet<PersistentPackage>(result);
        return dependentPackages;
    }

    private PersistentPackage createPackage(PersistentPackageManager pkgMgrEntity, PackageContext pkgCtx) throws PackageManagerException {
        Set<PackageContext> dependencyPackages;
        List<ScriptType> postUnInstallScripts;
        PersistentPackage newPackage = new PersistentPackage(pkgMgrEntity, pkgCtx.getPackageName(), pkgCtx.getPackageVersion());
        List<InstallFileType> files = pkgCtx.getInstallationFiles();
        if (files != null) {
            for (InstallFileType file : files) {
                PersistentFile installationFile = new PersistentFile(file.getName(), file.getDestPath());
                if (file.getType() != null) {
                    installationFile.setFileType(file.getType().toString());
                }
                newPackage.addInstallationFile(installationFile);
                installationFile.setPkg(newPackage);
            }
        }
        String relativePathToScriptStore = this.packageManagerCtx.getScriptStoreLocation(pkgCtx);
        List<ScriptType> preUnInstallScripts = pkgCtx.getPreUnInstallScripts();
        if (preUnInstallScripts != null) {
            for (ScriptType script : preUnInstallScripts) {
                String scriptName = script.getName();
                PersistentPreUnInstallScript preUnInstallScript = new PersistentPreUnInstallScript(newPackage, scriptName, relativePathToScriptStore);
                newPackage.addPreUnInstallScript(preUnInstallScript);
            }
        }
        if ((postUnInstallScripts = pkgCtx.getPostUnInstallScripts()) != null) {
            for (ScriptType script : postUnInstallScripts) {
                String scriptName = script.getName();
                PersistentPostUnInstallScript postUnInstallScript = new PersistentPostUnInstallScript(newPackage, scriptName, relativePathToScriptStore);
                newPackage.addPostUnInstallScript(postUnInstallScript);
            }
        }
        if ((dependencyPackages = pkgCtx.getDependencyPackages()) != null) {
            HashSet<PersistentDependency> dependencyPackagesForNewPackage = new HashSet<PersistentDependency>(dependencyPackages.size());
            newPackage.setDependencies(dependencyPackagesForNewPackage);
            for (PackageContext dependencyPkgCtx : dependencyPackages) {
                PersistentDependency dependency = new PersistentDependency();
                dependency.setDependentPackage(newPackage);
                PersistentPackage dependencyPackage = this.getInstalledPackage(dependencyPkgCtx.getPackageName());
                dependency.setDependeePackage(dependencyPackage);
                dependencyPackagesForNewPackage.add(dependency);
            }
        }
        return newPackage;
    }

    @Override
    public void removePackage(String name) throws PackageNotInstalledException {
        if (!this.isPackageInstalled(name)) {
            throw new PackageNotInstalledException(name);
        }
        PersistentPackage installedPackage = this.getInstalledPackage(name);
        this.removePackage(installedPackage);
    }

    private EntityManager getEntityManager() {
        EntityManager em = this.currentEntityManager.get();
        if (em == null) {
            em = this.entityMgrFactory.createEntityManager();
            this.currentEntityManager.set(em);
        }
        return em;
    }

    @Override
    public void removePackage(PersistentPackage installedPackage) {
        EntityManager em = this.getEntityManager();
        installedPackage = (PersistentPackage)em.merge((Object)installedPackage);
        em.remove((Object)installedPackage);
        logger.info((Object)("Deleted installed package = " + installedPackage.getPackageName()));
    }

    public void afterCompletion(int status) {
        this.currentEntityManager.set(null);
    }

    public void beforeCompletion() {
    }

    @Override
    public Set<String> getAllInstalledPackages() {
        HashSet<String> installedPackageNames = new HashSet<String>();
        EntityManager em = this.getEntityManager();
        PersistentPackageManager packageManager = this.getOrCreatePackageManagerEntity(this.packageManagerCtx);
        Query query = em.createQuery("select pkg.name from " + PersistentPackage.class.getSimpleName() + " pkg where pkg.packageManager.id=" + packageManager.getId());
        List result = query.getResultList();
        if (result != null) {
            installedPackageNames.addAll(result);
        }
        return installedPackageNames;
    }
}

