/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.packagemanager.entity;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.jboss.ejb3.packagemanager.entity.PersistentDependency;
import org.jboss.ejb3.packagemanager.entity.PersistentFile;
import org.jboss.ejb3.packagemanager.entity.PersistentPackageManager;
import org.jboss.ejb3.packagemanager.entity.PersistentPostUnInstallScript;
import org.jboss.ejb3.packagemanager.entity.PersistentPreUnInstallScript;

@Entity
@Table(name="package")
public class PersistentPackage {
    @Id
    private String name;
    private String version;
    @OneToMany(mappedBy="dependentPackage", cascade={CascadeType.ALL})
    private Set<PersistentDependency> dependencies;
    @OneToMany(mappedBy="pkg", cascade={CascadeType.ALL})
    private Set<PersistentFile> installationFiles;
    @OneToMany(mappedBy="installedPkg", cascade={CascadeType.ALL})
    private Set<PersistentPreUnInstallScript> preUnInstallScripts;
    @OneToMany(mappedBy="installedPkg", cascade={CascadeType.ALL})
    private Set<PersistentPostUnInstallScript> postUnInstallScripts;
    @ManyToOne
    @JoinColumn(name="package_manager_id")
    private PersistentPackageManager packageManager;

    private PersistentPackage() {
    }

    public PersistentPackage(PersistentPackageManager pkgMgr, String packageName, String packageVersion) {
        this.packageManager = pkgMgr;
        this.name = packageName;
        this.version = packageVersion;
    }

    public String getPackageName() {
        return this.name;
    }

    public String getPackageVersion() {
        return this.version;
    }

    public Set<PersistentFile> getInstallationFiles() {
        return this.installationFiles;
    }

    public void setInstallationFiles(Set<PersistentFile> installationFiles) {
        this.installationFiles = installationFiles;
    }

    public void addInstallationFile(PersistentFile file) {
        if (this.installationFiles == null) {
            this.installationFiles = new HashSet<PersistentFile>();
        }
        this.installationFiles.add(file);
    }

    public Set<PersistentPreUnInstallScript> getPreUnInstallScripts() {
        return this.preUnInstallScripts;
    }

    public void setPreUnInstallScript(Set<PersistentPreUnInstallScript> preUnInstallScripts) {
        this.preUnInstallScripts = preUnInstallScripts;
    }

    public void addPreUnInstallScript(PersistentPreUnInstallScript preUnInstallScrtipt) {
        if (this.preUnInstallScripts == null) {
            this.preUnInstallScripts = new HashSet<PersistentPreUnInstallScript>();
        }
        this.preUnInstallScripts.add(preUnInstallScrtipt);
    }

    public Set<PersistentPostUnInstallScript> getPostUnInstallScripts() {
        return this.postUnInstallScripts;
    }

    public void setPostUnInstallScript(Set<PersistentPostUnInstallScript> postUnInstallScripts) {
        this.postUnInstallScripts = postUnInstallScripts;
    }

    public void addPostUnInstallScript(PersistentPostUnInstallScript postUnInstallScript) {
        if (this.postUnInstallScripts == null) {
            this.postUnInstallScripts = new HashSet<PersistentPostUnInstallScript>();
        }
        this.postUnInstallScripts.add(postUnInstallScript);
    }

    public PersistentPackageManager getPackageManager() {
        return this.packageManager;
    }

    public void setPackageManager(PersistentPackageManager packageManager) {
        this.packageManager = packageManager;
    }

    public Set<PersistentDependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Set<PersistentDependency> dependencies) {
        this.dependencies = dependencies;
    }

    public void addDependency(PersistentDependency dependency) {
        if (this.dependencies == null) {
            this.dependencies = new HashSet<PersistentDependency>();
        }
        this.dependencies.add(dependency);
    }

    public void addDependencies(Set<PersistentDependency> dependencies) {
        if (this.dependencies == null) {
            this.dependencies = new HashSet<PersistentDependency>();
        }
        this.dependencies.addAll(dependencies);
    }

    public void removeDependency(PersistentDependency dependency) {
        if (this.dependencies == null) {
            return;
        }
        this.dependencies.remove(dependency);
    }

    public void removeDependency(PersistentPackage dependencyPackage) {
        if (this.dependencies == null) {
            return;
        }
        HashSet<PersistentDependency> copyOfDependencies = new HashSet<PersistentDependency>(this.dependencies);
        for (PersistentDependency dependency : copyOfDependencies) {
            if (!dependency.getDependentPackage().equals(dependencyPackage)) continue;
            this.dependencies.remove(dependency);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PersistentPackage)) {
            return false;
        }
        PersistentPackage otherPackge = (PersistentPackage)obj;
        return this.name == otherPackge.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

