/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.packagemanager.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.jboss.ejb3.packagemanager.PackageContext;
import org.jboss.ejb3.packagemanager.PackageManagerContext;
import org.jboss.ejb3.packagemanager.dependency.DependencyManager;
import org.jboss.ejb3.packagemanager.dependency.impl.IvyDependencyManager;
import org.jboss.ejb3.packagemanager.exception.DependencyResoultionException;
import org.jboss.ejb3.packagemanager.exception.InvalidPackageException;
import org.jboss.ejb3.packagemanager.exception.PackageRetrievalException;
import org.jboss.ejb3.packagemanager.metadata.DependenciesType;
import org.jboss.ejb3.packagemanager.metadata.InstallFileType;
import org.jboss.ejb3.packagemanager.metadata.PackageType;
import org.jboss.ejb3.packagemanager.metadata.PackagedDependency;
import org.jboss.ejb3.packagemanager.metadata.PostInstallType;
import org.jboss.ejb3.packagemanager.metadata.PostUnInstallType;
import org.jboss.ejb3.packagemanager.metadata.PreInstallType;
import org.jboss.ejb3.packagemanager.metadata.PreUnInstallType;
import org.jboss.ejb3.packagemanager.metadata.ScriptType;
import org.jboss.ejb3.packagemanager.metadata.SystemRequirementsType;
import org.jboss.ejb3.packagemanager.metadata.UnProcessedDependenciesType;
import org.jboss.ejb3.packagemanager.retriever.PackageRetriever;
import org.jboss.ejb3.packagemanager.retriever.impl.PackageRetrievalFactory;
import org.jboss.ejb3.packagemanager.util.IOUtil;
import org.jboss.ejb3.packagemanager.xml.PackageUnmarshaller;
import org.jboss.logging.Logger;

public class DefaultPackageContext
implements PackageContext {
    private static Logger logger = Logger.getLogger(DefaultPackageContext.class);
    private URL packageSource;
    private File packageRoot;
    private PackageManagerContext pkgMgrCtx;
    private PackageType pkg;
    private Set<PackageContext> dependencyPackages = new HashSet<PackageContext>();

    public DefaultPackageContext(PackageManagerContext pkgMgrCtx, URL packageSrc) throws InvalidPackageException, DependencyResoultionException {
        this.packageSource = packageSrc;
        this.pkgMgrCtx = pkgMgrCtx;
        this.initPackageContext();
        this.initPackageDependencies();
    }

    @Override
    public URL getPackageSource() {
        return this.packageSource;
    }

    @Override
    public File getPackageRoot() {
        return this.packageRoot;
    }

    public PackageType getPackage() {
        return this.pkg;
    }

    @Override
    public Set<PackageContext> getDependencyPackages() {
        return this.dependencyPackages;
    }

    @Override
    public List<InstallFileType> getInstallationFiles() {
        return Collections.unmodifiableList(this.pkg.getFiles());
    }

    @Override
    public String getPackageName() {
        return this.pkg.getName();
    }

    @Override
    public String getPackageVersion() {
        return this.pkg.getVersion();
    }

    @Override
    public List<ScriptType> getPostInstallScripts() {
        PostInstallType postInstall = this.pkg.getPostInstall();
        if (postInstall == null) {
            return Collections.EMPTY_LIST;
        }
        List<ScriptType> postInstallScripts = postInstall.getScripts();
        if (postInstallScripts == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(postInstallScripts);
    }

    @Override
    public List<ScriptType> getPreInstallScripts() {
        PreInstallType preInstall = this.pkg.getPreInstall();
        if (preInstall == null) {
            return Collections.EMPTY_LIST;
        }
        List<ScriptType> preInstallScripts = preInstall.getScripts();
        if (preInstallScripts == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(preInstallScripts);
    }

    @Override
    public List<ScriptType> getPostUnInstallScripts() {
        PostUnInstallType postUnInstall = this.pkg.getPostUninstall();
        if (postUnInstall == null) {
            return Collections.EMPTY_LIST;
        }
        List<ScriptType> postUnInstallScripts = postUnInstall.getScripts();
        if (postUnInstallScripts == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(postUnInstallScripts);
    }

    @Override
    public List<ScriptType> getPreUnInstallScripts() {
        PreUnInstallType preUnInstall = this.pkg.getPreUninstall();
        if (preUnInstall == null) {
            return Collections.EMPTY_LIST;
        }
        List<ScriptType> preUnInstallScripts = preUnInstall.getScripts();
        if (preUnInstallScripts == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(preUnInstallScripts);
    }

    @Override
    public SystemRequirementsType getSystemRequirements() {
        return this.pkg.getSystemRequirements();
    }

    private void initPackageDependencies() throws DependencyResoultionException, InvalidPackageException {
        this.dependencyPackages.addAll(this.getPackagedDependencyPackages());
        this.dependencyPackages.addAll(this.getUnprocessedDependencyPackages());
    }

    private Set<PackageContext> getUnprocessedDependencyPackages() throws DependencyResoultionException {
        DependenciesType dependencies = this.pkg.getDependencies();
        if (dependencies == null || dependencies.getUnProcessedDependencies() == null) {
            logger.debug((Object)("No unprocessed dependencies for " + this));
            return Collections.EMPTY_SET;
        }
        UnProcessedDependenciesType unProcessedDeps = dependencies.getUnProcessedDependencies();
        File dependencyFile = new File(this.getPackageRoot(), unProcessedDeps.getFile());
        if (!dependencyFile.exists()) {
            throw new DependencyResoultionException("Dependency file " + dependencyFile + " not found for " + this);
        }
        DependencyManager depManager = this.getDependencyManager(unProcessedDeps);
        if (depManager == null) {
            return Collections.EMPTY_SET;
        }
        Set<PackageContext> dependencyPackages = depManager.resolveDepedencies(this.pkgMgrCtx, this, unProcessedDeps);
        return dependencyPackages;
    }

    private Set<PackageContext> getPackagedDependencyPackages() throws InvalidPackageException, DependencyResoultionException {
        DependenciesType dependencies = this.pkg.getDependencies();
        if (dependencies == null || dependencies.getPackagedDependencies() == null || dependencies.getPackagedDependencies().isEmpty()) {
            logger.debug((Object)("No packaged dependency for " + this));
            return Collections.EMPTY_SET;
        }
        List<PackagedDependency> packagedDeps = dependencies.getPackagedDependencies();
        HashSet<PackageContext> depPackageCtxs = new HashSet<PackageContext>();
        for (PackagedDependency packagedDep : packagedDeps) {
            String relativePathToDependencyPackage = packagedDep.getFile();
            File dependencyPackage = new File(this.getPackageRoot(), relativePathToDependencyPackage);
            if (!dependencyPackage.exists()) {
                throw new DependencyResoultionException("packaged-dependency file " + dependencyPackage + " does not exist");
            }
            try {
                DefaultPackageContext dependencyPkgCtx = new DefaultPackageContext(this.pkgMgrCtx, dependencyPackage.toURI().toURL());
                depPackageCtxs.add(dependencyPkgCtx);
            }
            catch (MalformedURLException mue) {
                throw new RuntimeException(mue);
            }
        }
        return depPackageCtxs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPackageContext() throws InvalidPackageException {
        PackageRetriever pkgRetriever = PackageRetrievalFactory.getPackageRetriever(this.packageSource);
        try {
            File pkg = pkgRetriever.retrievePackage(this.pkgMgrCtx, this.packageSource);
            this.packageRoot = new File(this.pkgMgrCtx.getPackageManagerEnvironment().getPackageManagerBuildDir(), pkg.getName());
            if (!this.packageRoot.exists()) {
                this.packageRoot.mkdirs();
            }
            JarFile jar = null;
            try {
                jar = new JarFile(pkg);
                IOUtil.extractJarFile(this.packageRoot, jar);
            }
            finally {
                if (jar != null) {
                    jar.close();
                }
            }
            File packageXml = new File(this.packageRoot, "package.xml");
            if (!packageXml.exists()) {
                throw new InvalidPackageException(pkg + " is not a valid package - it does not contain a package.xml");
            }
        }
        catch (PackageRetrievalException pre) {
            throw new RuntimeException(pre);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Exception while creating context for " + this.packageSource, ioe);
        }
        this.initPackageMetadata();
    }

    private void initPackageMetadata() {
        File packageXmlFile = new File(this.packageRoot, "package.xml");
        try {
            this.pkg = new PackageUnmarshaller().unmarshal(packageXmlFile.toURI().toURL());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create metadata from package.xml file " + packageXmlFile, e);
        }
    }

    private DependencyManager getDependencyManager(UnProcessedDependenciesType dependencies) {
        if (dependencies == null) {
            return null;
        }
        String depManagerClassName = dependencies.getManager();
        if (depManagerClassName == null) {
            return new IvyDependencyManager();
        }
        Class<?> dependencyManager = null;
        try {
            dependencyManager = Class.forName(depManagerClassName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not load dependency manager: " + depManagerClassName, cnfe);
        }
        if (!DependencyManager.class.isAssignableFrom(dependencyManager)) {
            throw new RuntimeException("Dependency manager " + depManagerClassName + " does not implement " + DependencyManager.class);
        }
        try {
            return (DependencyManager)dependencyManager.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate dependency manager " + depManagerClassName, e);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Package [name=");
        String pkgName = this.pkg == null ? null : this.pkg.getName();
        sb.append(pkgName);
        sb.append(" ,version=");
        String pkgVersion = this.pkg == null ? null : this.pkg.getVersion();
        sb.append(pkgVersion);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int compareTo(PackageContext anotherPackage) {
        if (!this.getPackageName().equals(anotherPackage.getPackageName())) {
            throw new IllegalArgumentException("Cannot compare packages with two different names. This package name is " + this.getPackageName() + " ,another package name is " + anotherPackage.getPackageName());
        }
        return 0;
    }

    private class MockIvyArtifactInfo
    implements ArtifactInfo {
        private String version;

        public MockIvyArtifactInfo(String version) {
            this.version = version;
        }

        public long getLastModified() {
            return 0L;
        }

        public String getRevision() {
            return this.version;
        }
    }
}

