/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.packagemanager.installer;

import java.io.File;
import java.io.IOException;
import org.jboss.ejb3.packagemanager.PackageManagerContext;
import org.jboss.ejb3.packagemanager.exception.PackageManagerException;
import org.jboss.ejb3.packagemanager.installer.AbstractInstaller;
import org.jboss.ejb3.packagemanager.metadata.InstallFileType;
import org.jboss.ejb3.packagemanager.metadata.PackageType;
import org.jboss.ejb3.packagemanager.util.IOUtil;
import org.jboss.logging.Logger;

public class DefaultInstaller
extends AbstractInstaller {
    private static Logger logger = Logger.getLogger(DefaultInstaller.class);

    public DefaultInstaller(PackageManagerContext packageMgrCtx) {
        super(packageMgrCtx);
    }

    @Override
    protected void doInstall(InstallFileType fileMetadata, File fileToInstall, File dest) throws PackageManagerException {
        File destFile = new File(dest, fileMetadata.getName());
        PackageType pkgMeta = fileMetadata.getPackage();
        if (destFile.exists()) {
            logger.info((Object)("File " + fileMetadata.getName() + " from package: " + pkgMeta.getName() + " version: " + pkgMeta.getVersion() + " already exists in " + dest + " - installer will overwrite it"));
        }
        try {
            IOUtil.copy(fileToInstall, destFile);
        }
        catch (IOException e) {
            throw new PackageManagerException("Could not install file: " + fileMetadata.getName() + " from package: " + pkgMeta.getName() + " version: " + pkgMeta.getVersion() + " into " + dest.getAbsolutePath());
        }
    }
}

