/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.packagemanager.script.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.jboss.ejb3.packagemanager.PackageContext;
import org.jboss.ejb3.packagemanager.PackageManagerContext;
import org.jboss.ejb3.packagemanager.entity.PersistentPackage;
import org.jboss.ejb3.packagemanager.exception.ScriptProcessingException;
import org.jboss.ejb3.packagemanager.script.ScriptProcessor;
import org.jboss.logging.Logger;

public class AntScriptProcessor
implements ScriptProcessor {
    private static Logger logger = Logger.getLogger(AntScriptProcessor.class);

    @Override
    public void processPostInstallScript(PackageManagerContext pkgManagerCtx, PackageContext pkgCtx, File script) throws ScriptProcessingException {
        Project antProject = this.buildProject(script, pkgCtx.getPackageRoot(), this.getCommonAntProjectProperties(pkgManagerCtx));
        this.runTarget(antProject, "post-install");
    }

    @Override
    public void processPostUnInstallScript(PackageManagerContext pkgManagerCtx, PersistentPackage installedPackage, File script) throws ScriptProcessingException {
        Project antProject = this.buildProject(script, script.getParentFile(), this.getCommonAntProjectProperties(pkgManagerCtx));
        this.runTarget(antProject, "post-uninstall");
    }

    @Override
    public void processPreInstallScript(PackageManagerContext pkgManagerCtx, PackageContext pkgCtx, File script) throws ScriptProcessingException {
        Project antProject = this.buildProject(script, pkgCtx.getPackageRoot(), this.getCommonAntProjectProperties(pkgManagerCtx));
        this.runTarget(antProject, "pre-install");
    }

    @Override
    public void processPreUnInstallScript(PackageManagerContext pkgManagerCtx, PersistentPackage installedPackage, File script) throws ScriptProcessingException {
        Project antProject = this.buildProject(script, script.getParentFile(), this.getCommonAntProjectProperties(pkgManagerCtx));
        this.runTarget(antProject, "pre-uninstall");
    }

    private Project buildProject(File scriptFile, File baseDir, Map<String, String> antProperties) throws ScriptProcessingException {
        if (!scriptFile.exists()) {
            throw new ScriptProcessingException("Ant script file " + scriptFile + " does not exist");
        }
        Project antProject = new Project();
        antProject.addBuildListener((BuildListener)new AntBuildListener());
        antProject.setBaseDir(baseDir);
        if (antProperties != null) {
            Set<Map.Entry<String, String>> entries = antProperties.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                String propName = entry.getKey();
                String propVal = entry.getValue();
                antProject.setProperty(propName, propVal);
            }
        }
        antProject.init();
        ProjectHelper antProjHelper = ProjectHelper.getProjectHelper();
        antProjHelper.parse(antProject, (Object)scriptFile);
        return antProject;
    }

    private Map<String, String> getCommonAntProjectProperties(PackageManagerContext pkgManagerCtx) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("JBOSS_HOME", pkgManagerCtx.getJBossServerHome());
        props.put("PM_HOME", pkgManagerCtx.getPackageManagerEnvironment().getPackageManagerHome().getAbsolutePath());
        props.put("PM_TMP_DIR", pkgManagerCtx.getPackageManagerEnvironment().getPackageManagerTmpDir().getAbsolutePath());
        return props;
    }

    private void runTarget(Project antProject, String targetName) throws ScriptProcessingException {
        if (!antProject.getTargets().containsKey(targetName)) {
            throw new ScriptProcessingException("Target " + targetName + " not present in Ant script file");
        }
        try {
            antProject.executeTarget(targetName);
        }
        catch (Exception e) {
            throw new ScriptProcessingException("Exception while running target " + targetName + " in Ant script");
        }
    }

    private class AntBuildListener
    implements BuildListener {
        public void buildFinished(BuildEvent buildEvent) {
        }

        public void buildStarted(BuildEvent buildEvent) {
        }

        public void messageLogged(BuildEvent buildEvent) {
            int logLevel = buildEvent.getPriority();
            switch (logLevel) {
                case 3: {
                    logger.trace((Object)buildEvent.getMessage());
                    break;
                }
                case 4: {
                    logger.debug((Object)buildEvent.getMessage());
                    break;
                }
                case 2: {
                    logger.info((Object)buildEvent.getMessage());
                    break;
                }
                case 1: {
                    logger.warn((Object)buildEvent.getMessage());
                    break;
                }
                case 0: {
                    logger.error((Object)buildEvent.getMessage());
                    break;
                }
                default: {
                    logger.debug((Object)buildEvent.getMessage());
                }
            }
        }

        public void targetFinished(BuildEvent buildEvent) {
            Throwable failure = buildEvent.getException();
            if (failure != null) {
                logger.error((Object)(buildEvent.getTarget() + " failed"), failure);
            } else {
                logger.info((Object)(buildEvent.getTarget() + " completed successfully"));
            }
        }

        public void targetStarted(BuildEvent buildEvent) {
        }

        public void taskFinished(BuildEvent buildEvent) {
        }

        public void taskStarted(BuildEvent buildEvent) {
        }
    }
}

