/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.packagemanager.xml;

import java.net.URL;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidationSchemaFactory;
import org.jboss.ejb3.packagemanager.metadata.DependenciesType;
import org.jboss.ejb3.packagemanager.metadata.InstallFileType;
import org.jboss.ejb3.packagemanager.metadata.PackageType;
import org.jboss.ejb3.packagemanager.metadata.PackagedDependency;
import org.jboss.ejb3.packagemanager.metadata.PostInstallType;
import org.jboss.ejb3.packagemanager.metadata.PostUnInstallType;
import org.jboss.ejb3.packagemanager.metadata.PreInstallType;
import org.jboss.ejb3.packagemanager.metadata.PreUnInstallType;
import org.jboss.ejb3.packagemanager.metadata.ScriptType;
import org.jboss.ejb3.packagemanager.metadata.SystemRequirementsType;
import org.jboss.ejb3.packagemanager.metadata.UnProcessedDependenciesType;
import org.jboss.ejb3.packagemanager.metadata.impl.DependenciesImpl;
import org.jboss.ejb3.packagemanager.metadata.impl.InstallFileImpl;
import org.jboss.ejb3.packagemanager.metadata.impl.PackageImpl;
import org.jboss.ejb3.packagemanager.metadata.impl.PackagedDependencyImpl;
import org.jboss.ejb3.packagemanager.metadata.impl.PostInstallImpl;
import org.jboss.ejb3.packagemanager.metadata.impl.PostInstallScript;
import org.jboss.ejb3.packagemanager.metadata.impl.PostUnInstallImpl;
import org.jboss.ejb3.packagemanager.metadata.impl.PostUnInstallScript;
import org.jboss.ejb3.packagemanager.metadata.impl.PreInstallImpl;
import org.jboss.ejb3.packagemanager.metadata.impl.PreInstallScript;
import org.jboss.ejb3.packagemanager.metadata.impl.PreUnInstallImpl;
import org.jboss.ejb3.packagemanager.metadata.impl.PreUninstallScript;
import org.jboss.ejb3.packagemanager.metadata.impl.UnProcessedDependenciesImpl;

public class PackageUnmarshaller {
    public PackageType unmarshal(URL packageXml) throws Exception {
        XMLInputFactory2 xmlFactory = (XMLInputFactory2)XMLInputFactory2.newInstance();
        XMLStreamReader2 xmlStreamReader = (XMLStreamReader2)xmlFactory.createXMLStreamReader(packageXml.openStream());
        XMLValidationSchemaFactory validationSchemaFactory = XMLValidationSchemaFactory.newInstance((String)"http://www.w3.org/2001/XMLSchema");
        URL packageXsd = Thread.currentThread().getContextClassLoader().getResource("package.xsd");
        XMLValidationSchema schema = validationSchemaFactory.createSchema(packageXsd);
        xmlStreamReader.validateAgainst(schema);
        PackageType pkgMetadata = null;
        while (xmlStreamReader.hasNext()) {
            int event = xmlStreamReader.next();
            if (event != 1 || !xmlStreamReader.getLocalName().equals("package")) continue;
            pkgMetadata = this.processPackage(xmlStreamReader);
        }
        return pkgMetadata;
    }

    private PackageType processPackage(XMLStreamReader2 xmlStreamReader) throws Exception {
        PackageImpl pkgMeta = new PackageImpl();
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if ("name".equals(name)) {
                pkgMeta.setName(xmlStreamReader.getAttributeValue(i));
                continue;
            }
            if (!"version".equals(name)) continue;
            pkgMeta.setVersion(xmlStreamReader.getAttributeValue(i));
        }
        int event = xmlStreamReader.next();
        while (event != 2) {
            switch (event) {
                case 1: {
                    String childElement = xmlStreamReader.getLocalName();
                    if (childElement.equals("system-requirements")) {
                        SystemRequirementsType sysReqs = this.processSystemRequirements(pkgMeta, xmlStreamReader);
                        pkgMeta.setSystemRequirements(sysReqs);
                        break;
                    }
                    if (childElement.equals("file")) {
                        InstallFileType file = this.processFiles(pkgMeta, xmlStreamReader);
                        pkgMeta.addFile(file);
                        break;
                    }
                    if (childElement.equals("pre-install")) {
                        PreInstallType preInstall = this.processPreInstall(pkgMeta, xmlStreamReader);
                        pkgMeta.setPreInstall(preInstall);
                        break;
                    }
                    if (childElement.equals("post-install")) {
                        PostInstallType postInstall = this.processPostInstall(pkgMeta, xmlStreamReader);
                        pkgMeta.setPostInstall(postInstall);
                        break;
                    }
                    if (childElement.equals("pre-uninstall")) {
                        PreUnInstallType preUnInstall = this.processPreUnInstall(pkgMeta, xmlStreamReader);
                        pkgMeta.setPreUnInstall(preUnInstall);
                        break;
                    }
                    if (childElement.equals("post-uninstall")) {
                        PostUnInstallType postUnInstall = this.processPostUnInstall(pkgMeta, xmlStreamReader);
                        pkgMeta.setPostUnInstall(postUnInstall);
                        break;
                    }
                    if (!childElement.equals("dependencies")) break;
                    DependenciesType dependencies = this.processDependencies(pkgMeta, xmlStreamReader);
                    pkgMeta.setDependencies(dependencies);
                }
            }
            event = xmlStreamReader.next();
        }
        return pkgMeta;
    }

    private SystemRequirementsType processSystemRequirements(PackageType pkgMeta, XMLStreamReader2 xmlStreamReader) throws Exception {
        int event = xmlStreamReader.next();
        while (event != 2) {
            event = xmlStreamReader.next();
        }
        return null;
    }

    private InstallFileType processFiles(PackageType pkgMeta, XMLStreamReader2 xmlStreamReader) throws Exception {
        InstallFileImpl fileMeta = new InstallFileImpl(pkgMeta);
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if ("src-path".equals(name)) {
                fileMeta.setSrcPath(xmlStreamReader.getAttributeValue(i));
                continue;
            }
            if ("name".equals(name)) {
                fileMeta.setName(xmlStreamReader.getAttributeValue(i));
                continue;
            }
            if ("dest-path".equals(name)) {
                fileMeta.setDestPath(xmlStreamReader.getAttributeValue(i));
                continue;
            }
            if (!"type".equals(name)) continue;
            fileMeta.setType(xmlStreamReader.getAttributeValue(i));
        }
        int event = xmlStreamReader.next();
        while (event != 2) {
            event = xmlStreamReader.next();
        }
        return fileMeta;
    }

    private PreInstallType processPreInstall(PackageType pkgMeta, XMLStreamReader2 xmlStreamReader) throws Exception {
        PreInstallImpl preInstall = new PreInstallImpl(pkgMeta);
        int event = xmlStreamReader.next();
        while (event != 2) {
            switch (event) {
                case 1: {
                    String childElement = xmlStreamReader.getLocalName();
                    if (!childElement.equals("script")) break;
                    PreInstallScript script = this.processPreInstallScript(preInstall, xmlStreamReader);
                    preInstall.addScript(script);
                }
            }
            event = xmlStreamReader.next();
        }
        return preInstall;
    }

    private PreUnInstallType processPreUnInstall(PackageType pkgMeta, XMLStreamReader2 xmlStreamReader) throws Exception {
        PreUnInstallImpl preInstall = new PreUnInstallImpl(pkgMeta);
        int event = xmlStreamReader.next();
        while (event != 2) {
            switch (event) {
                case 1: {
                    String childElement = xmlStreamReader.getLocalName();
                    if (!childElement.equals("script")) break;
                    PreUninstallScript script = this.processPreUnInstallScript(preInstall, xmlStreamReader);
                    preInstall.addScript(script);
                }
            }
            event = xmlStreamReader.next();
        }
        return preInstall;
    }

    private PostInstallType processPostInstall(PackageType pkgMeta, XMLStreamReader2 xmlStreamReader) throws Exception {
        PostInstallImpl postInstall = new PostInstallImpl(pkgMeta);
        int event = xmlStreamReader.next();
        while (event != 2) {
            switch (event) {
                case 1: {
                    String childElement = xmlStreamReader.getLocalName();
                    if (!childElement.equals("script")) break;
                    PostInstallScript script = this.processPostInstallScript(postInstall, xmlStreamReader);
                    postInstall.addScript(script);
                }
            }
            event = xmlStreamReader.next();
        }
        return postInstall;
    }

    private PostUnInstallType processPostUnInstall(PackageType pkgMeta, XMLStreamReader2 xmlStreamReader) throws Exception {
        PostUnInstallImpl postUnInstall = new PostUnInstallImpl(pkgMeta);
        int event = xmlStreamReader.next();
        while (event != 2) {
            switch (event) {
                case 1: {
                    String childElement = xmlStreamReader.getLocalName();
                    if (!childElement.equals("script")) break;
                    PostUnInstallScript script = this.processPostUnInstallScript(postUnInstall, xmlStreamReader);
                    postUnInstall.addScript(script);
                }
            }
            event = xmlStreamReader.next();
        }
        return postUnInstall;
    }

    private PreInstallScript processPreInstallScript(PreInstallType preInstallMeta, XMLStreamReader2 xmlStreamReader) throws Exception {
        PreInstallScript preInstallScript = new PreInstallScript(preInstallMeta);
        this.processScript(preInstallScript, xmlStreamReader);
        return preInstallScript;
    }

    private PreUninstallScript processPreUnInstallScript(PreUnInstallType preUnInstallMeta, XMLStreamReader2 xmlStreamReader) throws Exception {
        PreUninstallScript preInstallScript = new PreUninstallScript(preUnInstallMeta);
        this.processScript(preInstallScript, xmlStreamReader);
        return preInstallScript;
    }

    private PostInstallScript processPostInstallScript(PostInstallType postInstallMeta, XMLStreamReader2 xmlStreamReader) throws Exception {
        PostInstallScript postInstallScript = new PostInstallScript(postInstallMeta);
        this.processScript(postInstallScript, xmlStreamReader);
        return postInstallScript;
    }

    private PostUnInstallScript processPostUnInstallScript(PostUnInstallType postUnInstall, XMLStreamReader2 xmlStreamReader) throws Exception {
        PostUnInstallScript postUnInstallScript = new PostUnInstallScript(postUnInstall);
        this.processScript(postUnInstallScript, xmlStreamReader);
        return postUnInstallScript;
    }

    private ScriptType processScript(ScriptType script, XMLStreamReader2 xmlStreamReader) throws Exception {
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String attrName = xmlStreamReader.getAttributeLocalName(i);
            if ("name".equals(attrName)) {
                script.setName(xmlStreamReader.getAttributeValue(i));
                continue;
            }
            if (!"path".equals(attrName)) continue;
            script.setPath(xmlStreamReader.getAttributeValue(i));
        }
        int event = xmlStreamReader.next();
        while (event != 2) {
            event = xmlStreamReader.next();
        }
        return script;
    }

    private DependenciesType processDependencies(PackageType pkgMetadata, XMLStreamReader2 xmlStreamReader) throws Exception {
        DependenciesImpl depMetadata = new DependenciesImpl(pkgMetadata);
        int event = xmlStreamReader.next();
        while (event != 2) {
            switch (event) {
                case 1: {
                    String childElement = xmlStreamReader.getLocalName();
                    if (childElement.equals("unprocessed-dependencies")) {
                        UnProcessedDependenciesType unProcessedDeps = this.processUnProcessedDependencies(pkgMetadata, xmlStreamReader);
                        depMetadata.setUnProcessedDependencies(unProcessedDeps);
                        break;
                    }
                    if (!childElement.equals("packaged-dependency")) break;
                    PackagedDependency packagedDep = this.processPackagedDependency(pkgMetadata, xmlStreamReader);
                    depMetadata.addPackagedDependency(packagedDep);
                }
            }
            event = xmlStreamReader.next();
        }
        return depMetadata;
    }

    private UnProcessedDependenciesType processUnProcessedDependencies(PackageType pkgMeta, XMLStreamReader2 xmlStreamReader) throws Exception {
        UnProcessedDependenciesImpl unProcessedDep = new UnProcessedDependenciesImpl(pkgMeta);
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if ("file".equals(name)) {
                unProcessedDep.setFile(xmlStreamReader.getAttributeValue(i));
                continue;
            }
            if (!"manager".equals(name)) continue;
            unProcessedDep.setManager(xmlStreamReader.getAttributeValue(i));
        }
        int event = xmlStreamReader.next();
        while (event != 2) {
            event = xmlStreamReader.next();
        }
        return unProcessedDep;
    }

    private PackagedDependency processPackagedDependency(PackageType pkgMeta, XMLStreamReader2 xmlStreamReader) throws Exception {
        PackagedDependencyImpl packagedDep = new PackagedDependencyImpl(pkgMeta);
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String name = xmlStreamReader.getAttributeLocalName(i);
            if (!"file".equals(name)) continue;
            packagedDep.setFile(xmlStreamReader.getAttributeValue(i));
        }
        int event = xmlStreamReader.next();
        while (event != 2) {
            event = xmlStreamReader.next();
        }
        return packagedDep;
    }
}

