/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.packagemanager.dependency.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.jboss.ejb3.packagemanager.PackageContext;
import org.jboss.ejb3.packagemanager.PackageManagerContext;
import org.jboss.ejb3.packagemanager.dependency.DependencyManager;
import org.jboss.ejb3.packagemanager.exception.DependencyResoultionException;
import org.jboss.ejb3.packagemanager.exception.InvalidPackageException;
import org.jboss.ejb3.packagemanager.impl.DefaultPackageContext;
import org.jboss.ejb3.packagemanager.metadata.UnProcessedDependenciesType;
import org.jboss.logging.Logger;

public class IvyDependencyManager
implements DependencyManager {
    public static final String PROPERTY_IVY_SETTINGS_FILE = "ivy.settings.file";
    private Logger logger = Logger.getLogger(IvyDependencyManager.class);

    @Override
    public Set<PackageContext> resolveDepedencies(PackageManagerContext pkgMgrContext, PackageContext pkgCtx, UnProcessedDependenciesType deps) throws DependencyResoultionException {
        IvySettings ivySettings = new IvySettings();
        ivySettings.setBaseDir(pkgCtx.getPackageRoot());
        this.logger.info((Object)("Ivy basedir is " + ivySettings.getBaseDir()));
        URL ivySettingsFile = this.getIvySettingsFile(pkgMgrContext, pkgCtx);
        if (ivySettingsFile == null) {
            throw new DependencyResoultionException("Ivy settings file not found for package manager " + pkgMgrContext);
        }
        this.logger.info((Object)("Ivy settings file " + ivySettingsFile + " being used for dependency resolution of " + pkgCtx));
        Ivy ivy = Ivy.newInstance((IvySettings)ivySettings);
        try {
            List problems;
            ivy.configure(ivySettingsFile);
            File dependencyFile = new File(pkgCtx.getPackageRoot(), deps.getFile());
            ResolveReport resolveReport = ivy.resolve(dependencyFile);
            if (resolveReport.hasError() && (problems = resolveReport.getAllProblemMessages()) != null && !problems.isEmpty()) {
                StringBuffer errorMsgs = new StringBuffer();
                for (String problem : problems) {
                    errorMsgs.append(problem);
                    errorMsgs.append("\n");
                }
                this.logger.error((Object)("Errors encountered during dependency resolution for package " + pkgCtx + " :"));
                this.logger.error((Object)errorMsgs);
                throw new DependencyResoultionException("Dependencies could not be resolved for package " + pkgCtx);
            }
            ModuleDescriptor md = resolveReport.getModuleDescriptor();
            File pkgTmpDir = new File(pkgMgrContext.getPackageManagerEnvironment().getPackageManagerTmpDir(), pkgCtx.getPackageName());
            pkgTmpDir.mkdir();
            ModuleRevisionId mRID = md.getModuleRevisionId();
            RetrieveOptions retrieveOptions = new RetrieveOptions();
            String pattern = pkgTmpDir.getAbsolutePath() + "/[organization]/[module]/[type]/[artifact]-[revision](-[classifier]).[ext]";
            retrieveOptions.setDestIvyPattern(pattern);
            retrieveOptions.setLog("default");
            int packagesRetrieved = ivy.retrieve(mRID, pattern, retrieveOptions);
            this.logger.info((Object)("Retrieved " + packagesRetrieved + " dependencies for package " + pkgCtx));
            HashSet<PackageContext> depPkgCtxs = new HashSet<PackageContext>();
            for (File depPkg : this.getJarFilesRecursively(pkgTmpDir)) {
                try {
                    DefaultPackageContext depPkgCtx = new DefaultPackageContext(pkgMgrContext, depPkg.toURI().toURL());
                    depPkgCtxs.add(depPkgCtx);
                }
                catch (InvalidPackageException e) {
                    this.logger.warn((Object)("Skipping dependency file " + depPkg + " since it's not a package. Was listed as a dependency of " + pkgCtx));
                }
            }
            return depPkgCtxs;
        }
        catch (IOException ioe) {
            throw new DependencyResoultionException(ioe);
        }
        catch (ParseException pe) {
            throw new DependencyResoultionException(pe);
        }
    }

    private URL getIvySettingsFile(PackageManagerContext pkgMrgCtx, PackageContext pkgCtx) {
        File ivySettingsInPackage = new File(pkgCtx.getPackageRoot(), "ivy-settings.xml");
        if (ivySettingsInPackage.exists()) {
            try {
                return ivySettingsInPackage.toURI().toURL();
            }
            catch (MalformedURLException mue) {
                throw new RuntimeException(mue);
            }
        }
        String ivySettingsLocation = System.getProperty(PROPERTY_IVY_SETTINGS_FILE);
        if (ivySettingsLocation != null) {
            File userSpecifiedIvySettings = new File(ivySettingsLocation);
            try {
                return userSpecifiedIvySettings.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Incorrect location " + userSpecifiedIvySettings + " specified for " + PROPERTY_IVY_SETTINGS_FILE + " property");
            }
        }
        return pkgMrgCtx.getClass().getClassLoader().getResource("ivy-default-settings.xml");
    }

    private List<File> getJarFilesRecursively(File parent) {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = parent.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        for (File file : filesDirs) {
            if (file.isFile() && file.getName().endsWith(".jar")) {
                result.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            List<File> deeperList = this.getJarFilesRecursively(file);
            result.addAll(deeperList);
        }
        return result;
    }
}

