/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.packagemanager.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import javax.transaction.TransactionManager;
import org.jboss.ejb3.packagemanager.PackageContext;
import org.jboss.ejb3.packagemanager.PackageManager;
import org.jboss.ejb3.packagemanager.PackageManagerContext;
import org.jboss.ejb3.packagemanager.PackageManagerEnvironment;
import org.jboss.ejb3.packagemanager.PackageVersionComparator;
import org.jboss.ejb3.packagemanager.db.DefaultDatabaseManager;
import org.jboss.ejb3.packagemanager.db.PackageDatabaseManager;
import org.jboss.ejb3.packagemanager.entity.PersistentFile;
import org.jboss.ejb3.packagemanager.entity.PersistentPackage;
import org.jboss.ejb3.packagemanager.entity.PersistentPostUnInstallScript;
import org.jboss.ejb3.packagemanager.entity.PersistentPreUnInstallScript;
import org.jboss.ejb3.packagemanager.exception.PackageManagerException;
import org.jboss.ejb3.packagemanager.exception.PackageNotInstalledException;
import org.jboss.ejb3.packagemanager.impl.DefaultPackageContext;
import org.jboss.ejb3.packagemanager.impl.DefaultPackageManagerContext;
import org.jboss.ejb3.packagemanager.installer.DefaultInstaller;
import org.jboss.ejb3.packagemanager.installer.Installer;
import org.jboss.ejb3.packagemanager.installer.MergingInstaller;
import org.jboss.ejb3.packagemanager.metadata.FileType;
import org.jboss.ejb3.packagemanager.metadata.InstallFileType;
import org.jboss.ejb3.packagemanager.metadata.ScriptType;
import org.jboss.ejb3.packagemanager.option.DefaultInstallOptions;
import org.jboss.ejb3.packagemanager.option.DefaultUnInstallOptions;
import org.jboss.ejb3.packagemanager.option.DefaultUpgradeOptions;
import org.jboss.ejb3.packagemanager.option.InstallOptions;
import org.jboss.ejb3.packagemanager.option.UnInstallOptions;
import org.jboss.ejb3.packagemanager.option.UpgradeOptions;
import org.jboss.ejb3.packagemanager.script.impl.AntScriptProcessor;
import org.jboss.ejb3.packagemanager.util.IOUtil;
import org.jboss.logging.Logger;

public class DefaultPackageManagerImpl
implements PackageManager {
    private static Logger logger = Logger.getLogger(DefaultPackageManagerImpl.class);
    private String installationServerHome;
    private PackageManagerEnvironment environment;
    private PackageManagerContext pkgMgrCtx;
    private PackageDatabaseManager pkgDatabaseManager;

    public DefaultPackageManagerImpl(PackageManagerEnvironment environment, String jbossHome) {
        this.environment = environment;
        this.installationServerHome = jbossHome;
        this.pkgMgrCtx = new DefaultPackageManagerContext(this);
        this.pkgDatabaseManager = new DefaultDatabaseManager(this.pkgMgrCtx);
    }

    @Override
    public PackageManagerEnvironment getPackageManagerEnvironment() {
        return this.environment;
    }

    @Override
    public String getServerHome() {
        return this.installationServerHome;
    }

    @Override
    public PackageDatabaseManager getDatabaseManager() {
        return this.pkgDatabaseManager;
    }

    @Override
    public void installPackage(String pkgPath) throws PackageManagerException {
        this.installPackage(pkgPath, (InstallOptions)new DefaultInstallOptions());
    }

    @Override
    public void installPackage(URL packageURL) throws PackageManagerException {
        this.installPackage(packageURL, (InstallOptions)new DefaultInstallOptions());
    }

    @Override
    public void installPackage(String pkgPath, InstallOptions installOptions) throws PackageManagerException {
        if (pkgPath == null) {
            throw new PackageManagerException("Package path is null");
        }
        URL packageURL = null;
        try {
            packageURL = this.getPackageURL(pkgPath);
        }
        catch (MalformedURLException mue) {
            throw new PackageManagerException("Cannot parse path " + pkgPath, mue);
        }
        this.installPackage(packageURL, installOptions);
    }

    @Override
    public void installPackage(URL packageURL, InstallOptions installOptions) throws PackageManagerException {
        if (packageURL == null) {
            throw new PackageManagerException("Package URL is null");
        }
        DefaultPackageContext pkgCtx = new DefaultPackageContext(this.pkgMgrCtx, packageURL);
        this.installPackage(pkgCtx, installOptions);
    }

    protected void installPackage(PackageContext pkgContext, InstallOptions installOptions) throws PackageManagerException {
        if (pkgContext == null) {
            throw new PackageManagerException("Package context is null");
        }
        boolean packageAlreadyInstalled = this.pkgDatabaseManager.isPackageInstalled(pkgContext.getPackageName());
        if (packageAlreadyInstalled) {
            throw new PackageManagerException("Package " + pkgContext + " is already installed");
        }
        logger.debug((Object)("New package " + pkgContext + " being installed"));
        if (pkgContext.getInstallationFiles() == null) {
            throw new PackageManagerException("There are no files to install for package: " + pkgContext);
        }
        this.installDependencies(pkgContext);
        this.preInstallPackage(pkgContext);
        for (InstallFileType fileToInstall : pkgContext.getInstallationFiles()) {
            Installer installer = this.getInstaller(fileToInstall);
            installer.install(pkgContext, fileToInstall);
        }
        this.postInstallPackage(pkgContext);
        this.storeScripts(pkgContext);
        this.pkgDatabaseManager.installPackage(pkgContext);
        logger.info((Object)("Installed " + pkgContext));
    }

    @Override
    public void removePackage(String packageName) throws PackageNotInstalledException, PackageManagerException {
        this.removePackage(packageName, new DefaultUnInstallOptions());
    }

    @Override
    public void removePackage(String packageName, UnInstallOptions uninstallOptions) throws PackageNotInstalledException, PackageManagerException {
        Set<PersistentPackage> dependentPackages;
        boolean isPackageInstalled = this.pkgDatabaseManager.isPackageInstalled(packageName);
        if (!isPackageInstalled) {
            throw new PackageNotInstalledException("Package " + packageName + " is not installed - so cannot be removed!");
        }
        PersistentPackage installedPackage = this.pkgDatabaseManager.getInstalledPackage(packageName);
        if (!uninstallOptions.isForceUnInstall() && (dependentPackages = this.pkgDatabaseManager.getDependentPackages(packageName)) != null && !dependentPackages.isEmpty()) {
            throw new PackageManagerException("Other packages are dependent on package " + packageName + " - cannot remove this package!");
        }
        this.preUnInstallPackage(installedPackage);
        DefaultInstaller installer = new DefaultInstaller(this.pkgMgrCtx);
        for (PersistentFile fileToUninstall : installedPackage.getInstallationFiles()) {
            installer.uninstall(installedPackage, fileToUninstall);
        }
        this.postUnInstallPackage(installedPackage);
        this.pkgDatabaseManager.removePackage(installedPackage);
        logger.info((Object)("Uninstalled " + packageName));
    }

    @Override
    public void updatePackage(String packageFilePath) throws PackageManagerException {
        this.updatePackage(packageFilePath, (UpgradeOptions)new DefaultUpgradeOptions());
    }

    @Override
    public void updatePackage(URL packageURL) throws PackageManagerException {
        this.updatePackage(packageURL, (UpgradeOptions)new DefaultUpgradeOptions());
    }

    @Override
    public void updatePackage(String packageFilePath, UpgradeOptions upgradeOptions) throws PackageManagerException {
        if (packageFilePath == null) {
            throw new PackageManagerException("Package path is null");
        }
        URL packageURL = null;
        try {
            packageURL = this.getPackageURL(packageFilePath);
        }
        catch (MalformedURLException mue) {
            throw new PackageManagerException("Cannot parse path " + packageFilePath, mue);
        }
        this.updatePackage(packageURL, upgradeOptions);
    }

    @Override
    public void updatePackage(URL packageURL, UpgradeOptions upgradeOptions) throws PackageManagerException {
        if (packageURL == null) {
            throw new PackageManagerException("Package URL is null");
        }
        DefaultPackageContext pkgCtx = new DefaultPackageContext(this.pkgMgrCtx, packageURL);
        this.updatePackage(pkgCtx, upgradeOptions);
    }

    protected void updatePackage(PackageContext pkgContext, UpgradeOptions upgradeOptions) throws PackageManagerException {
        String packageName = pkgContext.getPackageName();
        boolean isPackageInstalled = this.pkgDatabaseManager.isPackageInstalled(packageName);
        if (isPackageInstalled) {
            PackageVersionComparator comparator = new PackageVersionComparator();
            PersistentPackage installedPackage = this.pkgDatabaseManager.getInstalledPackage(packageName);
            int versionComparison = comparator.compare(installedPackage.getPackageVersion(), pkgContext.getPackageVersion());
            if (versionComparison == 0) {
                if (!upgradeOptions.isForceUpgrade()) {
                    logger.info((Object)("Skipping package upgrade, since package with name " + packageName + " and version " + installedPackage.getPackageVersion() + " is already installed"));
                    return;
                }
            } else if (versionComparison > 0) {
                logger.info((Object)("Skipping package upgrade, since a higher version " + installedPackage.getPackageVersion() + " compared to " + pkgContext.getPackageVersion() + " for package  " + packageName + " is already installed"));
                return;
            }
            logger.info((Object)("Upgrading package " + packageName + " from installed version " + installedPackage.getPackageVersion() + " to new version " + pkgContext.getPackageVersion()));
            DefaultUnInstallOptions uninstallOptions = new DefaultUnInstallOptions();
            uninstallOptions.setForcedUnInstall(true);
            this.removePackage(packageName, uninstallOptions);
        }
        this.installPackage(pkgContext, (InstallOptions)new DefaultInstallOptions());
    }

    @Override
    public TransactionManager getTransactionManager() {
        return null;
    }

    private URL getPackageURL(String pkgPath) throws MalformedURLException {
        URL url = null;
        try {
            url = new URL(pkgPath);
        }
        catch (MalformedURLException e) {
            logger.debug((Object)("Cannot handle " + pkgPath + " - will try using file: URL"));
            File file = new File(pkgPath);
            url = file.toURI().toURL();
        }
        return url;
    }

    private Installer getInstaller(InstallFileType file) {
        if (file == null) {
            return null;
        }
        FileType fileType = file.getType();
        if (fileType == FileType.CONFIG) {
            return new MergingInstaller(this.pkgMgrCtx);
        }
        return new DefaultInstaller(this.pkgMgrCtx);
    }

    private void storeScripts(PackageContext pkgCtx) throws PackageManagerException {
        List<ScriptType> preUnInstallScripts;
        String relativePathToScriptStoreDir = this.pkgMgrCtx.getScriptStoreLocation(pkgCtx);
        File scriptStoreDir = new File(this.getPackageManagerEnvironment().getPackageManagerHome(), relativePathToScriptStoreDir);
        if (!scriptStoreDir.exists()) {
            scriptStoreDir.mkdirs();
        }
        logger.debug((Object)("Scripts for " + pkgCtx + " will be stored in " + scriptStoreDir));
        List<ScriptType> postUnInstallScripts = pkgCtx.getPostUnInstallScripts();
        if (postUnInstallScripts != null) {
            for (ScriptType script : postUnInstallScripts) {
                this.storeScript(pkgCtx, script, scriptStoreDir);
            }
        }
        if ((preUnInstallScripts = pkgCtx.getPreUnInstallScripts()) != null) {
            for (ScriptType script : preUnInstallScripts) {
                this.storeScript(pkgCtx, script, scriptStoreDir);
            }
        }
    }

    private void storeScript(PackageContext pkgCtx, ScriptType script, File destDir) throws PackageManagerException {
        File scriptFile;
        File root;
        String scriptFileName = script.getName();
        File path = root = pkgCtx.getPackageRoot();
        if (script.getPath() != null) {
            path = new File(root, script.getPath());
        }
        if (!(scriptFile = new File(path, scriptFileName)).exists()) {
            throw new PackageManagerException("Script file " + scriptFile + " for " + pkgCtx + " does not exist!");
        }
        try {
            File destFile = new File(destDir, scriptFile.getName());
            IOUtil.copy(scriptFile, destFile);
            logger.debug((Object)("Stored script file " + scriptFile + " at " + destDir));
        }
        catch (IOException e) {
            throw new PackageManagerException("Could not store script due to exception ", e);
        }
    }

    protected void preInstallPackage(PackageContext pkgCtx) throws PackageManagerException {
        List<ScriptType> preInstallScripts = pkgCtx.getPreInstallScripts();
        if (preInstallScripts == null || preInstallScripts.isEmpty()) {
            logger.trace((Object)("There are no pre-install scripts for " + pkgCtx));
            return;
        }
        for (ScriptType script : preInstallScripts) {
            File scriptFile;
            File root;
            AntScriptProcessor scriptProcessor = new AntScriptProcessor();
            String scriptFileName = script.getName();
            File path = root = pkgCtx.getPackageRoot();
            if (script.getPath() != null) {
                path = new File(root, script.getPath());
            }
            if (!(scriptFile = new File(path, scriptFileName)).exists()) {
                throw new PackageManagerException("Script file " + scriptFile + " for " + pkgCtx + " does not exist!");
            }
            scriptProcessor.processPreInstallScript(this.pkgMgrCtx, pkgCtx, scriptFile);
        }
    }

    protected void preUnInstallPackage(PersistentPackage installedPackage) throws PackageManagerException {
        Set<PersistentPreUnInstallScript> preUnInstallScripts = installedPackage.getPreUnInstallScripts();
        if (preUnInstallScripts == null || preUnInstallScripts.isEmpty()) {
            logger.trace((Object)("There are no pre-uninstall scripts for package " + installedPackage.getPackageName()));
            return;
        }
        for (PersistentPreUnInstallScript script : preUnInstallScripts) {
            AntScriptProcessor scriptProcessor = new AntScriptProcessor();
            File packageManagerHome = this.pkgMgrCtx.getPackageManagerEnvironment().getPackageManagerHome();
            File scriptFileLocation = new File(packageManagerHome, script.getPath());
            File scriptFile = new File(scriptFileLocation, script.getName());
            if (!scriptFile.exists()) {
                throw new PackageManagerException("Script file " + scriptFile + " for package " + installedPackage.getPackageName() + " does not exist!");
            }
            scriptProcessor.processPreUnInstallScript(this.pkgMgrCtx, installedPackage, scriptFile);
        }
    }

    protected void postInstallPackage(PackageContext pkgCtx) throws PackageManagerException {
        List<ScriptType> postInstallScripts = pkgCtx.getPostInstallScripts();
        if (postInstallScripts == null || postInstallScripts.isEmpty()) {
            logger.trace((Object)("There are no post-install scripts for " + pkgCtx));
            return;
        }
        for (ScriptType script : postInstallScripts) {
            File scriptFile;
            File root;
            AntScriptProcessor scriptProcessor = new AntScriptProcessor();
            String scriptFileName = script.getName();
            File path = root = pkgCtx.getPackageRoot();
            if (script.getPath() != null) {
                path = new File(root, script.getPath());
            }
            if (!(scriptFile = new File(path, scriptFileName)).exists()) {
                throw new PackageManagerException("Script file " + scriptFile + " for " + pkgCtx + " does not exist!");
            }
            scriptProcessor.processPostInstallScript(this.pkgMgrCtx, pkgCtx, scriptFile);
        }
    }

    protected void postUnInstallPackage(PersistentPackage installedPackage) throws PackageManagerException {
        Set<PersistentPostUnInstallScript> postUnInstallScripts = installedPackage.getPostUnInstallScripts();
        if (postUnInstallScripts == null || postUnInstallScripts.isEmpty()) {
            logger.trace((Object)("There are no post-uninstall scripts for package " + installedPackage.getPackageName()));
            return;
        }
        for (PersistentPostUnInstallScript script : postUnInstallScripts) {
            AntScriptProcessor scriptProcessor = new AntScriptProcessor();
            File packageManagerHome = this.pkgMgrCtx.getPackageManagerEnvironment().getPackageManagerHome();
            File scriptFileLocation = new File(packageManagerHome, script.getPath());
            File scriptFile = new File(scriptFileLocation, script.getName());
            if (!scriptFile.exists()) {
                throw new PackageManagerException("Script file " + scriptFile + " for package " + installedPackage.getPackageName() + " does not exist!");
            }
            scriptProcessor.processPostUnInstallScript(this.pkgMgrCtx, installedPackage, scriptFile);
        }
    }

    protected void installDependencies(PackageContext pkgContext) throws PackageManagerException {
        Set<PackageContext> dependencies = pkgContext.getDependencyPackages();
        for (PackageContext dependencyPackage : dependencies) {
            logger.info((Object)("Installing dependency package : " + dependencyPackage + " for dependent package: " + pkgContext));
            this.updatePackage(dependencyPackage, (UpgradeOptions)new DefaultUpgradeOptions());
        }
    }

    @Override
    public Set<String> getAllInstalledPackages() {
        return this.pkgDatabaseManager.getAllInstalledPackages();
    }
}

