/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.packagemanager.installer;

import java.io.File;
import org.jboss.ejb3.packagemanager.PackageContext;
import org.jboss.ejb3.packagemanager.PackageManagerContext;
import org.jboss.ejb3.packagemanager.entity.PersistentFile;
import org.jboss.ejb3.packagemanager.entity.PersistentPackage;
import org.jboss.ejb3.packagemanager.exception.PackageManagerException;
import org.jboss.ejb3.packagemanager.installer.Installer;
import org.jboss.ejb3.packagemanager.metadata.InstallFileType;
import org.jboss.logging.Logger;

public abstract class AbstractInstaller
implements Installer {
    private static Logger logger = Logger.getLogger(AbstractInstaller.class);
    protected PackageManagerContext packageMgrContext;

    public AbstractInstaller(PackageManagerContext packageMgrCtx) {
        this.packageMgrContext = packageMgrCtx;
    }

    @Override
    public void uninstall(PersistentPackage pkg, PersistentFile installedFile) throws PackageManagerException {
        String jbossHome = pkg.getPackageManager().getJbossHome();
        File relativePathToFile = new File(jbossHome, installedFile.getInstalledPath());
        File fileToUninstall = new File(relativePathToFile, installedFile.getFileName());
        if (!fileToUninstall.exists()) {
            throw new PackageManagerException("Installed file missing: " + fileToUninstall.getAbsolutePath() + " - cannot uninstall!");
        }
        if (fileToUninstall.isDirectory()) {
            throw new PackageManagerException("Installed file is a directory : " + fileToUninstall.getAbsolutePath() + " - cannot uninstall!");
        }
        fileToUninstall.delete();
        logger.info((Object)("Uninstalled file " + fileToUninstall + " from package  " + pkg.getPackageName()));
    }

    @Override
    public final void install(PackageContext pkgCtx, InstallFileType fileMeta) throws PackageManagerException {
        File fileToInstall;
        File pkgRoot;
        File srcPathOfFileToInstall = pkgRoot = pkgCtx.getPackageRoot();
        if (fileMeta.getSrcPath() != null) {
            srcPathOfFileToInstall = new File(pkgRoot, fileMeta.getSrcPath());
        }
        if (!(fileToInstall = new File(srcPathOfFileToInstall, fileMeta.getName())).exists()) {
            throw new PackageManagerException(fileToInstall.getAbsolutePath() + " does not exist, package: " + pkgCtx + " being installed from " + pkgCtx.getPackageRoot() + " is probably corrupt!");
        }
        if (fileMeta.getDestPath() == null) {
            throw new PackageManagerException("File " + fileMeta.getName() + " in package: " + pkgCtx + " does not specify a destination");
        }
        String destServerHome = this.packageMgrContext.getJBossServerHome();
        File locationToInstall = new File(destServerHome, fileMeta.getDestPath());
        if (!locationToInstall.exists() || !locationToInstall.isDirectory()) {
            throw new PackageManagerException("dest-path " + locationToInstall.getAbsolutePath() + " for file: " + fileMeta.getName() + " in package: " + pkgCtx + " is either not present or is not a directory");
        }
        try {
            this.doInstall(fileMeta, fileToInstall, locationToInstall);
            logger.info((Object)("Installed file " + fileMeta.getName() + " from package: " + pkgCtx + " to " + locationToInstall.getAbsolutePath()));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected abstract void doInstall(InstallFileType var1, File var2, File var3) throws PackageManagerException;
}

