/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.packagemanager.retriever.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.ejb3.packagemanager.PackageManagerContext;
import org.jboss.ejb3.packagemanager.exception.PackageRetrievalException;
import org.jboss.ejb3.packagemanager.retriever.PackageRetriever;

public class HttpPackageRetriever
implements PackageRetriever {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File retrievePackage(PackageManagerContext pkgMgrCtx, URL packagePath) throws PackageRetrievalException {
        if (!packagePath.getProtocol().equals("http")) {
            throw new PackageRetrievalException("Cannot handle " + packagePath);
        }
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpGet httpGet = new HttpGet(packagePath.toExternalForm());
        HttpResponse httpResponse = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpGet);
        }
        catch (Exception e) {
            throw new PackageRetrievalException("Exception while retrieving package " + packagePath, e);
        }
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new PackageRetrievalException("Http retrieval wasn't successful, returned status code  " + httpResponse.getStatusLine().getStatusCode());
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        try {
            File tmpPkgFile = File.createTempFile("tmp", ".jar", pkgMgrCtx.getPackageManagerEnvironment().getPackageManagerTmpDir());
            FileOutputStream fos = new FileOutputStream(tmpPkgFile);
            BufferedOutputStream bos = null;
            BufferedInputStream bis = null;
            try {
                int length;
                bos = new BufferedOutputStream(fos);
                InputStream is = httpEntity.getContent();
                bis = new BufferedInputStream(is);
                byte[] content = new byte[4096];
                while ((length = bis.read(content)) != -1) {
                    bos.write(content, 0, length);
                }
                bos.flush();
            }
            finally {
                if (bos != null) {
                    bos.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            return tmpPkgFile;
        }
        catch (IOException ioe) {
            throw new PackageRetrievalException("Could not process the retrieved package", ioe);
        }
    }
}

