/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.clustered.objectfactory.session;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.Name;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aspects.remoting.ClusterChooserInterceptor;
import org.jboss.aspects.remoting.ClusteredPojiProxy;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
import org.jboss.ejb3.proxy.factory.ProxyFactory;
import org.jboss.ejb3.proxy.objectfactory.session.SessionProxyObjectFactory;
import org.jboss.ejb3.proxy.remoting.IsLocalProxyFactoryInterceptor;
import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionClusteredProxyObjectFactory
extends SessionProxyObjectFactory {
    private static final long serialVersionUID = 2550630984434261500L;
    private static final Logger log = Logger.getLogger((String)SessionClusteredProxyObjectFactory.class.getName());

    protected Object getProxy(ProxyFactory proxyFactory, Name name, Map<String, List<String>> referenceAddresses) {
        return this.createProxy(proxyFactory, name, referenceAddresses);
    }

    protected ProxyFactory createProxyFactoryProxy(Name name, Map<String, List<String>> refAddrs, String proxyFactoryRegistryKey) throws Exception {
        String url = this.getSingleRequiredReferenceAddressValue(name, refAddrs, "Remoting Host URL");
        assert (url != null && !url.trim().equals("")) : InvokerLocator.class.getSimpleName() + " URL is required, but is not specified; improperly bound reference in JNDI";
        InvokerLocator locator = new InvokerLocator(url);
        String partitionName = this.getSingleRequiredReferenceAddressValue(name, refAddrs, "Cluster Partition Name");
        assert (partitionName != null && !partitionName.trim().equals("")) : " Partition name is required, but is not specified; improperly bound reference in JNDI";
        String lbpClass = this.getSingleRequiredReferenceAddressValue(name, refAddrs, "Cluster Proxy Factory Load Balance Policy");
        assert (lbpClass != null && !lbpClass.trim().equals("")) : LoadBalancePolicy.class.getSimpleName() + " class name is required, but is not specified; improperly bound reference in JNDI";
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        LoadBalancePolicy loadBalancePolicy = (LoadBalancePolicy)tccl.loadClass(lbpClass).newInstance();
        FamilyWrapper wrapper = this.getFamilyWrapper(name, refAddrs);
        Class[] interfaces = new Class[]{this.getProxyFactoryClass()};
        Interceptor[] interceptors = new Interceptor[]{IsLocalProxyFactoryInterceptor.singleton, ClusterChooserInterceptor.singleton, InvokeRemoteInterceptor.singleton};
        ClusteredPojiProxy proxy = new ClusteredPojiProxy((Object)proxyFactoryRegistryKey, locator, interceptors, wrapper, loadBalancePolicy, partitionName, null);
        return (ProxyFactory)Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, (InvocationHandler)proxy);
    }

    private FamilyWrapper getFamilyWrapper(Name name, Map<String, List<String>> refAddrs) throws MalformedURLException {
        String familyName = this.getSingleRequiredReferenceAddressValue(name, refAddrs, "Cluster Family Name");
        assert (familyName != null && !familyName.trim().equals("")) : " Cluster family name is required, but is not specified; improperly bound reference in JNDI";
        ArrayList<InvokerLocator> targets = new ArrayList<InvokerLocator>();
        List<String> targetRefAddrs = refAddrs.get("Cluster Target Remoting Host URL");
        if (targetRefAddrs != null) {
            for (String url : targetRefAddrs) {
                targets.add(new InvokerLocator(url));
            }
        }
        log.debug((Object)("Creating " + FamilyWrapper.class.getSimpleName() + " for family " + familyName + " using targets " + targets));
        return new FamilyWrapper(familyName, targets);
    }
}

