/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.clustered.handler.session.stateless;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.ejb3.proxy.clustered.invocation.InvokableContextClusteredProxyInvocationHandler;
import org.jboss.ejb3.proxy.container.InvokableContext;
import org.jboss.ejb3.proxy.handler.session.stateless.StatelessRemoteProxyInvocationHandler;
import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
import org.jboss.remoting.InvokerLocator;

public class StatelessClusteredProxyInvocationHandler
extends StatelessRemoteProxyInvocationHandler {
    private static final long serialVersionUID = 2380301898566457305L;
    private FamilyWrapper family;
    private LoadBalancePolicy lbPolicy;
    private String partitionName;

    public StatelessClusteredProxyInvocationHandler(String containerName, String containerGuid, Interceptor[] interceptors, String businessInterfaceType, String url, FamilyWrapper family, LoadBalancePolicy lb, String partitionName) {
        super(containerName, containerGuid, interceptors, businessInterfaceType, url);
        assert (family != null) : "family is null";
        assert (lb != null) : "lb is null";
        assert (partitionName != null) : "partitionName is null";
        this.family = family;
        this.lbPolicy = lb;
        this.partitionName = partitionName;
    }

    protected InvokableContext createRemoteProxyToContainer(String url) {
        InvokerLocator locator = null;
        try {
            locator = new InvokerLocator(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not create " + InvokerLocator.class.getSimpleName() + " to url \"" + url + "\"", e);
        }
        Interceptor[] interceptors = this.getInterceptors();
        String containerName = this.getContainerName();
        assert (containerName != null && containerName.trim().length() > 0) : "Container Name must be set";
        InvokableContextClusteredProxyInvocationHandler handler = new InvokableContextClusteredProxyInvocationHandler(this.getContainerName(), this.getContainerGuid(), locator, interceptors, null, this.getFamilyWrapper(), this.getLoadBalancePolicy(), this.getPartitionName(), false);
        Class[] interfaces = new Class[]{InvokableContext.class};
        InvokableContext container = (InvokableContext)Proxy.newProxyInstance(InvokableContext.class.getClassLoader(), interfaces, (InvocationHandler)((Object)handler));
        return container;
    }

    public FamilyWrapper getFamilyWrapper() {
        return this.family;
    }

    public LoadBalancePolicy getLoadBalancePolicy() {
        return this.lbPolicy;
    }

    public String getPartitionName() {
        return this.partitionName;
    }
}

