/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.clustered.factory.session.stateless;

import org.jboss.aop.Advisor;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.advice.Interceptor;
import org.jboss.ejb3.proxy.clustered.handler.session.stateless.StatelessClusteredProxyInvocationHandler;
import org.jboss.ejb3.proxy.clustered.registry.ProxyClusteringInfo;
import org.jboss.ejb3.proxy.clustered.registry.ProxyClusteringRegistry;
import org.jboss.ejb3.proxy.factory.session.stateless.StatelessSessionRemoteProxyFactory;
import org.jboss.ejb3.proxy.handler.session.SessionProxyInvocationHandler;
import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.remoting.InvokerLocator;

public class StatelessSessionClusteredProxyFactory
extends StatelessSessionRemoteProxyFactory {
    private static final String STACK_NAME_CLUSTERED_STATELESS_SESSION_CLIENT_INTERCEPTORS = "ClusteredStatelessSessionClientInterceptors";
    private static final Logger log = Logger.getLogger(StatelessSessionClusteredProxyFactory.class);
    private final ProxyClusteringRegistry registry;
    private ProxyClusteringInfo beanClusteringInfo;

    public StatelessSessionClusteredProxyFactory(String name, String containerName, String containerGuid, JBossSessionBeanMetaData metadata, ClassLoader classloader, String url, Advisor advisor, ProxyClusteringRegistry registry, String interceptorStack) {
        super(name, containerName, containerGuid, metadata, classloader, url, advisor, interceptorStack);
        assert (registry != null) : "registry is null";
        this.registry = registry;
    }

    protected String getInterceptorStackName() {
        return STACK_NAME_CLUSTERED_STATELESS_SESSION_CLIENT_INTERCEPTORS;
    }

    public void start() throws Exception {
        super.start();
        this.beanClusteringInfo = this.registry.registerClusteredBean(this.getContainerName(), this.getName(), this.getMetadata(), new InvokerLocator(this.getUrl()));
        log.debug((Object)("Registering with Remoting Dispatcher under name \"" + this.getName() + "\": " + (Object)((Object)this)));
        Dispatcher.singleton.registerTarget((Object)this.getName(), (Object)this);
    }

    public void stop() throws Exception {
        this.registry.unregisterClusteredBean(this.beanClusteringInfo);
        log.debug((Object)("Unregistering name \"" + this.getName() + "\" from Remoting Dispatcher"));
        Dispatcher.singleton.unregisterTarget((Object)this.getName());
        super.stop();
    }

    protected SessionProxyInvocationHandler createBusinessDefaultInvocationHandler() {
        return this.createInvocationHandler(null, false);
    }

    protected SessionProxyInvocationHandler createBusinessInterfaceSpecificInvocationHandler(String businessInterfaceName) {
        return this.createInvocationHandler(businessInterfaceName, false);
    }

    protected SessionProxyInvocationHandler createEjb2xComponentInterfaceInvocationHandler() {
        return this.createInvocationHandler(null, false);
    }

    protected SessionProxyInvocationHandler createHomeInvocationHandler() {
        return this.createInvocationHandler(null, true);
    }

    private SessionProxyInvocationHandler createInvocationHandler(String businessInterfaceName, boolean isOnlyHome) {
        LoadBalancePolicy lbp;
        String containerName = this.getContainerName();
        String containerGuid = this.getContainerGuid();
        String url = this.getUrl();
        Interceptor[] interceptors = this.getInterceptors();
        Class<? extends LoadBalancePolicy> policyClass = isOnlyHome ? this.beanClusteringInfo.getHomeLoadBalancePolicy() : this.beanClusteringInfo.getLoadBalancePolicy();
        try {
            lbp = policyClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate LoadBalancePolicy class " + policyClass);
        }
        StatelessClusteredProxyInvocationHandler handler = new StatelessClusteredProxyInvocationHandler(containerName, containerGuid, interceptors, businessInterfaceName, url, this.beanClusteringInfo.getFamilyWrapper(), lbp, this.beanClusteringInfo.getPartitionName());
        return handler;
    }
}

