/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
  *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.proxy.impl.handler.session;

import java.io.Serializable;
import java.lang.reflect.Method;

import org.jboss.aop.advice.Interceptor;
import org.jboss.ejb3.proxy.impl.remoting.ProxyRemotingUtils;
import org.jboss.ejb3.proxy.spi.container.InvokableContext;

/**
 * SessionRemoteProxyInvocationHandler
 *
 * @author <a href="mailto:andrew.rubinger@jboss.org">ALR</a>
 * @version $Revision: $
 */
public class SessionRemoteProxyInvocationHandler extends SessionProxyInvocationHandlerBase implements Serializable
{

   // --------------------------------------------------------------------------------||
   // Class Members ------------------------------------------------------------------||
   // --------------------------------------------------------------------------------||

   private static final long serialVersionUID = 1L;

   // --------------------------------------------------------------------------------||
   // Instance Members ---------------------------------------------------------------||
   // --------------------------------------------------------------------------------||

   private String url;

   /**
    * Remote hook to the container
    */
   private final InvokableContext container;

   // --------------------------------------------------------------------------------||
   // Constructor --------------------------------------------------------------------||
   // --------------------------------------------------------------------------------||

   /**
    * For use by singleton-proxy.
    *
    * @param containerName
    * @param containerGuid
    * @param interceptors
    * @param businessInterfaceType
    * @param url
    */
   @Deprecated
   public SessionRemoteProxyInvocationHandler(final String containerName, final String containerGuid,
         final Interceptor[] interceptors, final String businessInterfaceType, final String url)
   {
      this(containerName, containerGuid, interceptors, businessInterfaceType, null, url);
   }

   /**
    * Constructor
    * 
    * @param containerName The name of the target container
    * @param containerGuid The globally-unique name of the container
    * @param businessInterfaceType The possibly null businessInterfaceType
    *   marking this invocation hander as specific to a given
    *   EJB3 Business Interface
    * @param url The URL to the Remote Host
    * @param interceptors The interceptors to apply to invocations upon this handler
    */
   public SessionRemoteProxyInvocationHandler(final String containerName, final String containerGuid,
         final Interceptor[] interceptors, final String businessInterfaceType, final Object target, final String url)
   {
      super(containerName, containerGuid, interceptors, businessInterfaceType, target);

      // Set properties
      this.setUrl(url);
      this.container = ProxyRemotingUtils.createRemoteProxyToContainer(this.getContainerName(),
            this.getContainerGuid(), url, this.getInterceptors(), target);
   }

   // --------------------------------------------------------------------------------||
   // Required Implementations -------------------------------------------------------||
   // --------------------------------------------------------------------------------||

   /**
    * {@inheritDoc}
    * @see org.jboss.ejb3.proxy.impl.handler.session.SessionProxyInvocationHandlerBase#getContainer(java.lang.reflect.Method, java.lang.Object[])
    */
   @Override
   protected InvokableContext getContainer(final Method method, final Object[] args)
   {
      return container;
   }

   // --------------------------------------------------------------------------------||
   // Accessors / Mutators -----------------------------------------------------------||
   // --------------------------------------------------------------------------------||

   public String getUrl()
   {
      return url;
   }

   public void setUrl(String url)
   {
      this.url = url;
   }

}
