/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.impl.factory.session.service;

import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Set;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.proxy.impl.factory.ProxyFactoryBase;
import org.jboss.ejb3.proxy.impl.factory.session.service.ServiceProxyFactory;
import org.jboss.ejb3.proxy.impl.handler.session.SessionProxyInvocationHandler;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossServiceBeanMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceProxyFactoryBase
extends ProxyFactoryBase
implements ServiceProxyFactory {
    private static final Logger log = Logger.getLogger(ServiceProxyFactoryBase.class);
    private JBossServiceBeanMetaData metadata;
    private Constructor<?> proxyConstructor;

    public ServiceProxyFactoryBase(String name, String containerName, String containerGuid, JBossServiceBeanMetaData metadata, ClassLoader classloader, Advisor advisor) {
        super(name, containerName, containerGuid, classloader, advisor);
        this.setMetadata(metadata);
    }

    @Override
    public Object createProxyDefault() {
        Constructor<?> constructor = this.getProxyConstructor();
        assert (constructor != null) : "Constructor for Default Proxy was null; perhaps the " + ServiceProxyFactory.class.getSimpleName() + " was not properly started?";
        SessionProxyInvocationHandler handler = this.createInvocationHandler();
        try {
            return constructor.newInstance(handler);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not create the Default Proxy for " + this.getMetadata().getEjbName(), t);
        }
    }

    @Override
    public void start() throws Exception {
        boolean hasBusinessInterfaces;
        super.start();
        HashSet defaultProxyInterfaces = new HashSet();
        Set<String> businessInterfaceTypes = this.getBusinessInterfaceTypes();
        HashSet businessInterfaceClasses = new HashSet();
        boolean bl = hasBusinessInterfaces = businessInterfaceTypes != null && businessInterfaceTypes.size() > 0;
        if (hasBusinessInterfaces) {
            for (String businessInterfaceType : businessInterfaceTypes) {
                Class<?> businessInterface = null;
                try {
                    businessInterface = this.getClassLoader().loadClass(businessInterfaceType);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException("Could not find specified @Service Bean Business Interface \"" + businessInterfaceType + "\" in " + ClassLoader.class.getSimpleName() + " for EJB " + this.getMetadata().getEjbName(), cnfe);
                }
                businessInterfaceClasses.add(businessInterface);
            }
        }
        defaultProxyInterfaces.addAll(businessInterfaceClasses);
        Constructor<?> businessInterfacesConstructor = this.createProxyConstructor(defaultProxyInterfaces, this.getClassLoader());
        log.debug((Object)("Created @Service Bean Default EJB3 Business Proxy Constructor implementing " + defaultProxyInterfaces));
        this.setProxyConstructor(businessInterfacesConstructor);
    }

    @Override
    public void stop() throws Exception {
        super.stop();
    }

    protected abstract Set<String> getBusinessInterfaceTypes();

    protected abstract SessionProxyInvocationHandler createInvocationHandler();

    public JBossServiceBeanMetaData getMetadata() {
        return this.metadata;
    }

    protected void setMetadata(JBossServiceBeanMetaData metadata) {
        this.metadata = metadata;
    }

    protected Constructor<?> getProxyConstructor() {
        return this.proxyConstructor;
    }

    protected void setProxyConstructor(Constructor<?> proxyConstructor) {
        this.proxyConstructor = proxyConstructor;
    }
}

