/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.impl.remoting;

import java.io.Serializable;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.logging.Logger;

public class IsLocalProxyFactoryInterceptor
implements Interceptor,
Serializable {
    private static final long serialVersionUID = -1264055696758370812L;
    private static final long stamp = System.currentTimeMillis();
    public static final IsLocalProxyFactoryInterceptor singleton = new IsLocalProxyFactoryInterceptor();
    private static final Logger log = Logger.getLogger(IsLocalProxyFactoryInterceptor.class);
    private long marshalledStamp = stamp;

    public String getName() {
        return this.getClass().getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object oid = invocation.getMetaData((Object)"DISPATCHER", (Object)"OID");
        if (this.isLocal()) {
            log.debug((Object)("Proxyfactory with id " + oid + " is local, will now check if the local dispatcher has the registered instance"));
            if (Dispatcher.singleton.isRegistered(oid)) {
                InvocationResponse response = Dispatcher.singleton.invoke(invocation);
                invocation.setResponseContextInfo(response.getContextInfo());
                log.debug((Object)("Local invocation for ProxyFactory with id " + oid + " - handling locally via current Dispatcher"));
                return response.getResponse();
            }
        }
        log.debug((Object)("NOT a local invocation for ProxyFactory with id " + oid + " -  passing the control to next interceptor"));
        return invocation.invokeNext();
    }

    private boolean isLocal() {
        return stamp == this.marshalledStamp;
    }
}

