/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.factory.session.stateful;

import java.util.Set;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.ejb3.proxy.factory.session.SessionProxyFactory;
import org.jboss.ejb3.proxy.factory.session.stateful.StatefulSessionProxyFactoryBase;
import org.jboss.ejb3.proxy.handler.session.SessionProxyInvocationHandler;
import org.jboss.ejb3.proxy.handler.session.stateful.StatefulRemoteProxyInvocationHandler;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulSessionRemoteProxyFactory
extends StatefulSessionProxyFactoryBase
implements SessionProxyFactory {
    private static final Logger log = Logger.getLogger(StatefulSessionRemoteProxyFactory.class);
    private static final String STACK_NAME_STATEFUL_SESSION_CLIENT_INTERCEPTORS = "StatefulSessionClientInterceptors";
    private String url;

    public StatefulSessionRemoteProxyFactory(String name, String containerName, String containerGuid, JBossSessionBeanMetaData metadata, ClassLoader classloader, String url, Advisor advisor) {
        super(name, containerName, containerGuid, metadata, classloader, advisor);
        this.setUrl(url);
    }

    @Override
    protected final Set<String> getBusinessInterfaceTypes() {
        return this.getMetadata().getBusinessRemotes();
    }

    @Override
    protected final String getHomeType() {
        return this.getMetadata().getHome();
    }

    @Override
    protected final String getEjb2xInterfaceType() {
        return this.getMetadata().getRemote();
    }

    @Override
    protected String getInterceptorStackName() {
        return STACK_NAME_STATEFUL_SESSION_CLIENT_INTERCEPTORS;
    }

    @Override
    protected SessionProxyInvocationHandler createInvocationHandler(String businessInterfaceName) {
        String containterName = this.getContainerName();
        String url = this.getUrl();
        String containerGuid = this.getContainerGuid();
        Interceptor[] interceptors = this.getInterceptors();
        StatefulRemoteProxyInvocationHandler handler = new StatefulRemoteProxyInvocationHandler(containterName, containerGuid, interceptors, businessInterfaceName, url);
        return handler;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

