/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.objectfactory;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
import org.jboss.aspects.remoting.PojiProxy;
import org.jboss.ejb3.common.registrar.spi.Ejb3Registrar;
import org.jboss.ejb3.common.registrar.spi.Ejb3RegistrarLocator;
import org.jboss.ejb3.common.registrar.spi.NotBoundException;
import org.jboss.ejb3.proxy.factory.ProxyFactory;
import org.jboss.ejb3.proxy.remoting.IsLocalProxyFactoryInterceptor;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProxyObjectFactory
implements ObjectFactory,
Serializable {
    private static final Logger log = Logger.getLogger((String)ProxyObjectFactory.class.getName());

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        log.debug((Object)(ProxyObjectFactory.class.getName() + " servicing request for " + name.toString()));
        assert (Reference.class.isAssignableFrom(obj.getClass())) : "Object bound at " + name.toString() + " was not of expected type " + Reference.class.getName();
        Reference ref = (Reference)obj;
        Map<String, List<String>> refAddrs = this.getReferenceAddresses(ref);
        String proxyFactoryRegistryKey = this.getSingleRequiredReferenceAddressValue(name, refAddrs, "ProxyFactoryKey");
        ProxyFactory proxyFactory = null;
        try {
            Ejb3Registrar registrar = Ejb3RegistrarLocator.locateRegistrar();
            try {
                Object pfObj = registrar.lookup((Object)proxyFactoryRegistryKey);
                assert (pfObj != null) : ProxyFactory.class.getName() + " from key " + proxyFactoryRegistryKey + " was null";
                assert (pfObj instanceof ProxyFactory) : " Object obtained from key " + proxyFactoryRegistryKey + " was expected to be of type " + ProxyFactory.class.getName() + " but was instead " + pfObj;
                proxyFactory = (ProxyFactory)pfObj;
            }
            catch (NotBoundException nbe) {
                throw new RuntimeException("Could not obtain " + ProxyFactory.class.getSimpleName() + " from expected key \"" + proxyFactoryRegistryKey + "\"", nbe);
            }
        }
        catch (NotBoundException nbe) {
            String url = this.getSingleRequiredReferenceAddressValue(name, refAddrs, "Remoting Host URL");
            assert (url != null && !url.trim().equals("")) : InvokerLocator.class.getSimpleName() + " URL is required, but is not specified; improperly bound reference in JNDI";
            InvokerLocator locator = new InvokerLocator(url);
            Interceptor[] interceptors = new Interceptor[]{IsLocalProxyFactoryInterceptor.singleton, InvokeRemoteInterceptor.singleton};
            PojiProxy handler = new PojiProxy((Object)proxyFactoryRegistryKey, locator, interceptors);
            Class[] interfaces = new Class[]{this.getProxyFactoryClass()};
            proxyFactory = (ProxyFactory)Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, (InvocationHandler)handler);
        }
        Object proxy = this.getProxy(proxyFactory, name, refAddrs);
        assert (proxy != null) : "Proxy returned from " + proxyFactory + " was null.";
        return proxy;
    }

    protected String getSingleRequiredReferenceAddressValue(Name name, Map<String, List<String>> referenceAddresses, String refAddrType) {
        String value = this.getSingleReferenceAddressValue(name, referenceAddresses, refAddrType);
        assert (value != null && !value.trim().equals("")) : "Exactly one " + RefAddr.class.getSimpleName() + " of type " + refAddrType + " must be defined, none found";
        return value;
    }

    protected String getSingleReferenceAddressValue(Name name, Map<String, List<String>> referenceAddresses, String refAddrType) {
        List<String> values = referenceAddresses.get(refAddrType);
        assert (values == null || values.size() == 1) : "Only one " + RefAddr.class.getSimpleName() + " of type " + refAddrType + " may be defined, instead found: " + values;
        String value = null;
        if (values != null) {
            value = values.get(0).trim();
        }
        return value;
    }

    protected abstract Object getProxy(ProxyFactory var1, Name var2, Map<String, List<String>> var3);

    protected abstract Class<?> getProxyFactoryClass();

    private Map<String, List<String>> getReferenceAddresses(Reference ref) {
        HashMap<String, List<String>> referenceAddresses = new HashMap<String, List<String>>();
        int count = 0;
        Enumeration<RefAddr> refAddrs = ref.getAll();
        while (refAddrs.hasMoreElements()) {
            RefAddr refAddr = refAddrs.nextElement();
            String type = refAddr.getType();
            Class<String> expectedContentsType = String.class;
            Object refAddrContent = refAddr.getContent();
            assert (refAddrContent != null) : "Encountered Reference Address of type " + type + " but with null Content";
            assert (expectedContentsType.isAssignableFrom(refAddrContent.getClass())) : "Content of Reference Address of type \"" + type + "\" at index " + count + " was not of expected Java type " + expectedContentsType.getName();
            String content = (String)refAddr.getContent();
            if (!referenceAddresses.containsKey(type)) {
                referenceAddresses.put(type, new ArrayList());
            }
            ((List)referenceAddresses.get(type)).add(content);
            log.trace((Object)("Found reference type \"" + type + "\" with content \"" + content + "\""));
            ++count;
        }
        return referenceAddresses;
    }
}

