/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.factory.session.stateful;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Set;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.common.registrar.spi.Ejb3Registrar;
import org.jboss.ejb3.common.registrar.spi.Ejb3RegistrarLocator;
import org.jboss.ejb3.common.registrar.spi.NotBoundException;
import org.jboss.ejb3.proxy.container.StatefulSessionInvokableContext;
import org.jboss.ejb3.proxy.factory.session.SessionProxyFactoryBase;
import org.jboss.ejb3.proxy.factory.session.stateful.StatefulSessionProxyFactory;
import org.jboss.ejb3.proxy.handler.session.stateful.StatefulProxyInvocationHandlerBase;
import org.jboss.ejb3.proxy.intf.StatefulSessionProxy;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StatefulSessionProxyFactoryBase
extends SessionProxyFactoryBase
implements StatefulSessionProxyFactory {
    private static final Logger log = Logger.getLogger(StatefulSessionProxyFactoryBase.class);
    private transient StatefulSessionInvokableContext container;

    public StatefulSessionProxyFactoryBase(String name, String containerName, String containerGuid, JBossSessionBeanMetaData metadata, ClassLoader classloader, Advisor advisor) {
        super(name, containerName, containerGuid, metadata, classloader, advisor);
    }

    @Override
    @Deprecated
    protected Set<Class<?>> getReturnTypesFromCreateMethods(Class<?> homeInterface) {
        return this.getReturnTypesFromCreateMethods(homeInterface, false);
    }

    @Override
    protected Set<Class<?>> getCommonProxyInterfaces() {
        Set<Class<?>> interfaces = super.getCommonProxyInterfaces();
        interfaces.add(StatefulSessionProxy.class);
        return interfaces;
    }

    @Override
    public Object createProxyHome() {
        Serializable sessionId = this.getNewSessionId();
        return this.createProxyHome(sessionId);
    }

    @Override
    public Object createProxyDefault() {
        Serializable sessionId = this.getNewSessionId();
        return this.createProxyDefault(sessionId);
    }

    @Override
    public Object createProxyBusiness(String businessInterfaceName) {
        Serializable sessionId = this.getNewSessionId();
        return this.createProxyBusiness(sessionId, businessInterfaceName);
    }

    @Override
    public Object createProxyEjb2x() {
        Serializable sessionId = this.getNewSessionId();
        return this.createProxyEjb2x(sessionId);
    }

    @Override
    public Object createProxyHome(Serializable sessionId) {
        Object proxy = super.createProxyHome();
        this.associateProxyWithSession(proxy, sessionId);
        return proxy;
    }

    @Override
    public Object createProxyDefault(Serializable sessionId) {
        Object proxy = super.createProxyDefault();
        this.associateProxyWithSession(proxy, sessionId);
        return proxy;
    }

    @Override
    public Object createProxyBusiness(Serializable sessionId, String businessInterfaceName) {
        Object proxy = super.createProxyBusiness(businessInterfaceName);
        this.associateProxyWithSession(proxy, sessionId);
        return proxy;
    }

    @Override
    public Object createProxyEjb2x(Serializable sessionId) {
        Object proxy = super.createProxyEjb2x();
        this.associateProxyWithSession(proxy, sessionId);
        return proxy;
    }

    protected void associateProxyWithSession(Object proxy, Serializable sessionId) {
        InvocationHandler handler = Proxy.getInvocationHandler(proxy);
        assert (handler instanceof StatefulProxyInvocationHandlerBase) : "SFSB Proxy must be of type " + StatefulProxyInvocationHandlerBase.class.getName();
        StatefulProxyInvocationHandlerBase sHandler = (StatefulProxyInvocationHandlerBase)handler;
        sHandler.setSessionId(sessionId);
    }

    protected Serializable getNewSessionId() {
        StatefulSessionInvokableContext container = this.getContainer();
        Serializable sessionId = null;
        try {
            sessionId = container.createSession();
        }
        catch (NotBoundException e) {
            throw new RuntimeException("Could not obtain a new Session ID from SFSB Container \"" + container + "\"", e);
        }
        catch (RuntimeException re) {
            log.error((Object)"Could not obtain new Session ID from SFSB Container", (Throwable)re);
            throw re;
        }
        return sessionId;
    }

    protected StatefulSessionInvokableContext obtainContainer() {
        StatefulSessionInvokableContext container = null;
        String containerName = this.getContainerName();
        try {
            Object obj = Ejb3RegistrarLocator.locateRegistrar().lookup((Object)containerName);
            assert (obj instanceof StatefulSessionInvokableContext) : "Container retrieved from " + Ejb3Registrar.class.getSimpleName() + " was not of expected type " + StatefulSessionInvokableContext.class.getName() + " but was instead " + obj;
            container = (StatefulSessionInvokableContext)obj;
        }
        catch (NotBoundException nbe) {
            throw new RuntimeException(StatefulSessionProxyFactory.class.getSimpleName() + " " + this + " has defined container name \"" + containerName + "\", but this could not be found in the " + Ejb3Registrar.class.getSimpleName());
        }
        return container;
    }

    public StatefulSessionInvokableContext getContainer() {
        if (this.container == null) {
            this.setContainer(this.obtainContainer());
        }
        return this.container;
    }

    public void setContainer(StatefulSessionInvokableContext container) {
        this.container = container;
    }
}

