/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.handler.session;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.jboss.aop.advice.Interceptor;
import org.jboss.ejb3.common.lang.SerializableMethod;
import org.jboss.ejb3.proxy.container.InvokableContext;
import org.jboss.ejb3.proxy.handler.NotEligibleForDirectInvocationException;
import org.jboss.ejb3.proxy.handler.session.SessionProxyInvocationHandlerBase;
import org.jboss.ejb3.proxy.handler.session.SessionSpecProxyInvocationHandler;
import org.jboss.logging.Logger;

public abstract class SessionSpecProxyInvocationHandlerBase
extends SessionProxyInvocationHandlerBase
implements SessionSpecProxyInvocationHandler,
Serializable {
    private static final Logger log = Logger.getLogger(SessionSpecProxyInvocationHandlerBase.class);
    private String businessInterfaceType;

    protected SessionSpecProxyInvocationHandlerBase(String containerName, String containerGuid, Interceptor[] interceptors, String businessInterfaceType) {
        super(containerName, containerGuid, interceptors);
        this.setBusinessInterfaceType(businessInterfaceType);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return this.handleInvocationDirectly(proxy, args, method);
        }
        catch (NotEligibleForDirectInvocationException nefdie) {
            log.debug((Object)("Couldn't handle invocation directly within " + this + ": " + nefdie.getMessage()));
            String actualClass = this.getBusinessInterfaceType();
            SerializableMethod invokedMethod = new SerializableMethod(method, actualClass);
            InvokableContext container = this.getContainer();
            if (args == null) {
                args = new Object[]{};
            }
            Object result = container.invoke(proxy, invokedMethod, args);
            return result;
        }
    }

    protected String getBusinessInterfaceType() {
        return this.businessInterfaceType;
    }

    protected void setBusinessInterfaceType(String businessInterfaceType) {
        this.businessInterfaceType = businessInterfaceType;
    }
}

