/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.objectfactory.session;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.naming.Name;
import org.jboss.ejb3.proxy.factory.ProxyFactory;
import org.jboss.ejb3.proxy.factory.session.SessionProxyFactory;
import org.jboss.ejb3.proxy.objectfactory.Ejb3RegistrarProxyObjectFactory;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SessionProxyObjectFactory
extends Ejb3RegistrarProxyObjectFactory {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(SessionProxyObjectFactory.class);

    protected Object createProxy(ProxyFactory factory, Name name, Map<String, List<String>> referenceAddresses) {
        Object proxy = null;
        boolean hasHome = this.hasHome(name, referenceAddresses);
        boolean hasBusiness = this.hasBusiness(name, referenceAddresses);
        SessionProxyFactory sFactory = null;
        try {
            sFactory = (SessionProxyFactory)SessionProxyFactory.class.cast(factory);
        }
        catch (ClassCastException cce) {
            throw new RuntimeException(ProxyFactory.class.getSimpleName() + " used in " + SessionProxyObjectFactory.class.getSimpleName() + " must be of type " + SessionProxyFactory.class.getName() + " but was instead " + factory, cce);
        }
        if (hasHome && hasBusiness) {
            proxy = sFactory.createProxyDefault();
            log.debug((Object)"Created Proxy for both EJB2.x Home and EJB3 Business Interfaces.");
        } else if (hasHome) {
            proxy = sFactory.createProxyHome();
            log.debug((Object)"Created Proxy for EJB2.x Home Interface(s)");
        } else if (hasBusiness) {
            String type = null;
            type = this.hasLocalBusiness(referenceAddresses) ? "Local Business Interface" : "Remote Business Interface";
            List<String> businessInterfaces = referenceAddresses.get(type);
            if (businessInterfaces.size() == 1) {
                String businessInterface = businessInterfaces.get(0);
                proxy = sFactory.createProxyBusiness(businessInterface);
                log.debug((Object)("Created Proxy of type " + proxy.getClass().getSimpleName() + " for EJB3 Business Interface: " + businessInterface));
                ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                ClassLoader proxyCl = proxy.getClass().getClassLoader();
                if (tcl != proxyCl) {
                    Class<?> proxyClass = proxy.getClass();
                    assert (Proxy.isProxyClass(proxyClass)) : "Assumed Proxy is not an instance of " + Proxy.class.getName();
                    InvocationHandler handler = Proxy.getInvocationHandler(proxy);
                    Class<?>[] proxyInterfaces = proxyClass.getInterfaces();
                    HashSet ourClInterfaces = new HashSet();
                    for (Class<?> proxyInterface : proxyInterfaces) {
                        String proxyInterfaceName = proxyInterface.getName();
                        Class<?> ourDefinedProxyInterface = null;
                        try {
                            ourDefinedProxyInterface = Class.forName(proxyInterfaceName, false, tcl);
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException("Can not find interface declared by Proxy in our CL + " + tcl, e);
                        }
                        ourClInterfaces.add(ourDefinedProxyInterface);
                    }
                    proxy = Proxy.newProxyInstance(tcl, ourClInterfaces.toArray(new Class[0]), handler);
                }
            } else {
                proxy = sFactory.createProxyDefault();
                log.debug((Object)("Created Proxy of type " + proxy.getClass().getSimpleName() + " for EJB3 Business Interfaces: " + businessInterfaces));
            }
        } else {
            throw new RuntimeException(factory + " found associated with JNDI Binding " + name.toString() + " is not bound to create/return any valid EJB2.x Home or EJB3 Business Interfaces");
        }
        String containerName = this.getSingleRequiredReferenceAddressValue(name, referenceAddresses, "EJB Container Name");
        assert (containerName != null && containerName.trim().length() > 0) : "Container Name must be specified via reference address + \"EJB Container Name\"";
        return proxy;
    }

    @Override
    protected Class<?> getProxyFactoryClass() {
        return SessionProxyFactory.class;
    }

    protected boolean hasHome(Name name, Map<String, List<String>> referenceAddresses) {
        boolean hasHome = false;
        boolean hasLocalHome = referenceAddresses.containsKey("EJB 2.x Local Home Interface");
        boolean hasRemoteHome = referenceAddresses.containsKey("EJB 2.x Remote Home Interface");
        String errorMessage = "ObjectFactory at JNDI \"" + name.toString() + "\" contains references to both local and remote homes";
        assert (!hasLocalHome || !hasRemoteHome) : errorMessage;
        if (hasLocalHome && hasRemoteHome) {
            throw new RuntimeException(errorMessage);
        }
        hasHome = hasLocalHome || hasRemoteHome;
        return hasHome;
    }

    protected boolean hasBusiness(Name name, Map<String, List<String>> referenceAddresses) {
        boolean hasBusiness = false;
        boolean hasLocalBusiness = this.hasLocalBusiness(referenceAddresses);
        boolean hasRemoteBusiness = this.hasRemoteBusiness(referenceAddresses);
        String errorMessage = "ObjectFactory at JNDI \"" + name.toString() + "\" contains references to both local and remote business interfaces";
        assert (!hasLocalBusiness || !hasRemoteBusiness) : errorMessage;
        if (hasLocalBusiness && hasRemoteBusiness) {
            throw new RuntimeException(errorMessage);
        }
        hasBusiness = hasLocalBusiness || hasRemoteBusiness;
        return hasBusiness;
    }

    protected boolean hasLocalBusiness(Map<String, List<String>> referenceAddresses) {
        return referenceAddresses.containsKey("Local Business Interface");
    }

    protected boolean hasRemoteBusiness(Map<String, List<String>> referenceAddresses) {
        return referenceAddresses.containsKey("Remote Business Interface");
    }
}

