/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.remoting;

import org.jboss.ejb3.common.registrar.spi.Ejb3RegistrarLocator;
import org.jboss.ejb3.common.registrar.spi.NotBoundException;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.transport.Connector;

public class ProxyRemotingUtils {
    private static final Logger log = Logger.getLogger(ProxyRemotingUtils.class);
    private static final String OBJECT_NAME_REMOTING_CONNECTOR = "org.jboss.ejb3.RemotingConnector";
    protected static String DEFAULT_CLIENT_BINDING;
    protected static final String DEFAULT_CLIENT_BINDING_IF_CONNECTOR_NOT_FOUND = "socket://0.0.0.0:3873";

    public static synchronized String getDefaultClientBinding() {
        if (DEFAULT_CLIENT_BINDING == null) {
            try {
                Connector connector = (Connector)Ejb3RegistrarLocator.locateRegistrar().lookup((Object)OBJECT_NAME_REMOTING_CONNECTOR, Connector.class);
                try {
                    DEFAULT_CLIENT_BINDING = connector.getInvokerLocator();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not obtain " + InvokerLocator.class.getSimpleName() + " from EJB3 Remoting Connector", e);
                }
            }
            catch (NotBoundException nbe) {
                log.warn((Object)"Could not find the EJB3 Remoting Connector bound in the Object Store (MC) at the expected name: org.jboss.ejb3.RemotingConnector.  Defaulting a client bind URL to socket://0.0.0.0:3873");
                DEFAULT_CLIENT_BINDING = DEFAULT_CLIENT_BINDING_IF_CONNECTOR_NOT_FOUND;
            }
        }
        return DEFAULT_CLIENT_BINDING;
    }
}

