/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.handler;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import org.jboss.aop.advice.Interceptor;
import org.jboss.ejb3.common.lang.SerializableMethod;
import org.jboss.ejb3.common.registrar.spi.Ejb3Registrar;
import org.jboss.ejb3.common.registrar.spi.Ejb3RegistrarLocator;
import org.jboss.ejb3.proxy.container.InvokableContext;
import org.jboss.ejb3.proxy.handler.NotEligibleForDirectInvocationException;
import org.jboss.ejb3.proxy.handler.ProxyInvocationHandler;
import org.jboss.logging.Logger;

public abstract class ProxyInvocationHandlerBase
implements ProxyInvocationHandler,
Serializable {
    private Interceptor[] interceptors;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ProxyInvocationHandlerBase.class);
    private static final String METHOD_NAME_TO_STRING = "toString";
    private static final String METHOD_NAME_EQUALS = "equals";
    private static final String METHOD_NAME_HASH_CODE = "hashCode";
    private static final SerializableMethod METHOD_TO_STRING;
    private static final SerializableMethod METHOD_EQUALS;
    private static final SerializableMethod METHOD_HASH_CODE;
    private String containerName;
    private String containerGuid;

    protected ProxyInvocationHandlerBase(String containerName, String containerGuid, Interceptor[] interceptors) {
        this.setContainerName(containerName);
        this.setContainerGuid(containerGuid);
        this.setInterceptors(interceptors);
    }

    protected Object handleInvocationDirectly(Object proxy, Object[] args, Method invokedMethod) throws NotEligibleForDirectInvocationException {
        assert (invokedMethod != null) : "Invoked Method was not set upon invocation of " + this.getClass().getName();
        if (invokedMethod.equals(METHOD_EQUALS.toMethod())) {
            assert (args.length == 1) : "Invocation for 'equals' should have exactly one argument, instead was: " + invokedMethod;
            Object argument = args[0];
            return this.invokeEquals(proxy, argument);
        }
        if (invokedMethod.equals(METHOD_TO_STRING.toMethod())) {
            assert (Proxy.isProxyClass(proxy.getClass())) : "Specified proxy invoked is not of type " + Proxy.class.getName();
            Class<?>[] implementedInterfaces = proxy.getClass().getInterfaces();
            HashSet interfacesSet = new HashSet();
            for (Class<?> interfaze : implementedInterfaces) {
                interfacesSet.add(interfaze);
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Proxy to ");
            sb.append(this.getContainerName());
            sb.append(" implementing ");
            sb.append(interfacesSet);
            return sb.toString();
        }
        if (invokedMethod.equals(METHOD_HASH_CODE.toMethod())) {
            return this.invokeHashCode(proxy);
        }
        throw new NotEligibleForDirectInvocationException("Current invocation \"" + invokedMethod + "\" is not eligible for direct handling by " + this);
    }

    protected InvokableContext getContainerLocally() {
        Object obj = Ejb3RegistrarLocator.locateRegistrar().lookup((Object)this.getContainerName());
        assert (obj instanceof InvokableContext) : "Container retrieved from " + Ejb3Registrar.class.getSimpleName() + " was not of expected type " + InvokableContext.class.getName() + " but was instead " + obj;
        return (InvokableContext)obj;
    }

    public Object invoke(Object proxy, SerializableMethod method, Object[] args) throws Throwable {
        try {
            return this.handleInvocationDirectly(proxy, args, method.toMethod());
        }
        catch (NotEligibleForDirectInvocationException nefdie) {
            log.debug((Object)("Couldn't handle invocation directly within " + this + ": " + nefdie.getMessage()));
            InvokableContext container = this.getContainer();
            if (args == null) {
                args = new Object[]{};
            }
            Object result = container.invoke(proxy, method, args);
            return result;
        }
    }

    protected abstract InvokableContext getContainer();

    protected abstract boolean invokeEquals(Object var1, Object var2);

    protected abstract int invokeHashCode(Object var1);

    protected String getContainerName() {
        return this.containerName;
    }

    protected void setContainerName(String containerName) {
        assert (containerName != null && containerName.trim().length() > 0) : "Container Name must be specified";
        this.containerName = containerName;
    }

    protected Interceptor[] getInterceptors() {
        return this.interceptors;
    }

    private void setInterceptors(Interceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    protected String getContainerGuid() {
        return this.containerGuid;
    }

    private void setContainerGuid(String containerGuid) {
        this.containerGuid = containerGuid;
    }

    static {
        try {
            METHOD_TO_STRING = new SerializableMethod(Object.class.getDeclaredMethod(METHOD_NAME_TO_STRING, new Class[0]), Object.class);
            METHOD_EQUALS = new SerializableMethod(Object.class.getDeclaredMethod(METHOD_NAME_EQUALS, Object.class), Object.class);
            METHOD_HASH_CODE = new SerializableMethod(Object.class.getDeclaredMethod(METHOD_NAME_HASH_CODE, new Class[0]), Object.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException("Methods for handling directly by the InvocationHandler were not initialized correctly", nsme);
        }
    }
}

