/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.handler.session.stateless;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.jboss.aop.advice.Interceptor;
import org.jboss.ejb3.proxy.handler.session.SessionProxyInvocationHandler;
import org.jboss.ejb3.proxy.handler.session.SessionSpecProxyInvocationHandlerBase;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;

public abstract class StatelessProxyInvocationHandlerBase
extends SessionSpecProxyInvocationHandlerBase
implements SessionProxyInvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(StatelessProxyInvocationHandlerBase.class);

    public StatelessProxyInvocationHandlerBase(String containerName, String containerGuid, Interceptor[] interceptors) {
        this(containerName, containerGuid, interceptors, null);
    }

    public StatelessProxyInvocationHandlerBase(String containerName, String containerGuid, Interceptor[] interceptors, String businessInterfaceType) {
        super(containerName, containerGuid, interceptors, businessInterfaceType);
    }

    protected boolean invokeEquals(Object proxy, Object argument) {
        if (!Proxy.isProxyClass(argument.getClass())) {
            return false;
        }
        StatelessProxyInvocationHandlerBase proxyHandler = this.getInvocationHandler(proxy);
        InvocationHandler argumentHandler = Proxy.getInvocationHandler(argument);
        if (!(argumentHandler instanceof StatelessProxyInvocationHandlerBase)) {
            return false;
        }
        StatelessProxyInvocationHandlerBase proxySHandler = proxyHandler;
        StatelessProxyInvocationHandlerBase argumentSHandler = (StatelessProxyInvocationHandlerBase)argumentHandler;
        String proxyContainerName = proxySHandler.getContainerName();
        assert (proxyContainerName != null) : "Container Name for " + proxySHandler + " was not set and is required";
        if (!proxyContainerName.equals(argumentSHandler.getContainerName())) {
            return false;
        }
        String proxyBusinessInterface = proxySHandler.getBusinessInterfaceType();
        String argumentBusinessInterface = argumentSHandler.getBusinessInterfaceType();
        if (proxyBusinessInterface == null && argumentBusinessInterface != null) {
            return false;
        }
        return proxyBusinessInterface == null || proxyBusinessInterface.equals(argumentBusinessInterface);
    }

    protected int invokeHashCode(Object proxy) {
        StatelessProxyInvocationHandlerBase handler = this.getInvocationHandler(proxy);
        String unique = handler.getContainerName() + handler.getBusinessInterfaceType();
        return unique.hashCode();
    }

    protected StatelessProxyInvocationHandlerBase getInvocationHandler(Object proxy) {
        InvocationHandler handler = Proxy.getInvocationHandler(proxy);
        assert (handler instanceof StatelessProxyInvocationHandlerBase) : "Expected " + InvocationHandler.class.getSimpleName() + " of type " + StatelessProxyInvocationHandlerBase.class.getName() + ", but instead was " + handler;
        return (StatelessProxyInvocationHandlerBase)handler;
    }

    public Object getAsynchronousProxy(Object proxy) {
        throw new NotImplementedException("ALR");
    }
}

