/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.remoting;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import org.jboss.aop.advice.Interceptor;
import org.jboss.ejb3.common.registrar.spi.Ejb3RegistrarLocator;
import org.jboss.ejb3.common.registrar.spi.NotBoundException;
import org.jboss.ejb3.proxy.container.InvokableContext;
import org.jboss.ejb3.proxy.invocation.InvokableContextStatefulRemoteProxyInvocationHack;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.transport.Connector;

public class ProxyRemotingUtils {
    private static final Logger log = Logger.getLogger(ProxyRemotingUtils.class);
    private static final String OBJECT_NAME_REMOTING_CONNECTOR = "org.jboss.ejb3.RemotingConnector";
    protected static String DEFAULT_CLIENT_BINDING;
    protected static final String DEFAULT_CLIENT_BINDING_IF_CONNECTOR_NOT_FOUND = "socket://0.0.0.0:3873";

    public static synchronized String getDefaultClientBinding() {
        if (DEFAULT_CLIENT_BINDING == null) {
            try {
                Connector connector = (Connector)Ejb3RegistrarLocator.locateRegistrar().lookup((Object)OBJECT_NAME_REMOTING_CONNECTOR, Connector.class);
                try {
                    DEFAULT_CLIENT_BINDING = connector.getInvokerLocator();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not obtain " + InvokerLocator.class.getSimpleName() + " from EJB3 Remoting Connector", e);
                }
            }
            catch (NotBoundException nbe) {
                log.warn((Object)"Could not find the EJB3 Remoting Connector bound in the Object Store (MC) at the expected name: org.jboss.ejb3.RemotingConnector.  Defaulting a client bind URL to socket://0.0.0.0:3873");
                DEFAULT_CLIENT_BINDING = DEFAULT_CLIENT_BINDING_IF_CONNECTOR_NOT_FOUND;
            }
        }
        return DEFAULT_CLIENT_BINDING;
    }

    public static InvokableContext createRemoteProxyToContainer(String containerName, String containerGuid, String url, Interceptor[] interceptors, Serializable sessionId) {
        if (url == null || url.trim().length() == 0) {
            url = ProxyRemotingUtils.getDefaultClientBinding();
        }
        InvokerLocator locator = null;
        try {
            locator = new InvokerLocator(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not create " + InvokerLocator.class.getSimpleName() + " to url \"" + url + "\"", e);
        }
        InvokableContextStatefulRemoteProxyInvocationHack handler = new InvokableContextStatefulRemoteProxyInvocationHack(containerName, containerGuid, locator, interceptors, sessionId);
        Class[] interfaces = new Class[]{InvokableContext.class};
        InvokableContext container = (InvokableContext)Proxy.newProxyInstance(InvokableContext.class.getClassLoader(), interfaces, (InvocationHandler)((Object)handler));
        return container;
    }
}

