/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.timerservice.naming;

import java.util.Hashtable;

import javax.ejb.EJBContext;
import javax.ejb.TimerService;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.spi.ObjectFactory;

import org.jboss.ejb3.context.CurrentInvocationContext;


/**
 * An implementation of {@link ObjectFactory} which is responsible for returing
 * a {@link TimerService} for the current {@link EJBContext}
 *
 * @author Jaikiran Pai
 * @version $Revision: $
 */
public class TimerServiceObjectFactory implements ObjectFactory
{

   /**
    * Returns {@link TimerService} for the current {@link EJBContext}
    */
   @Override
   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment)
         throws Exception
   {
      // get hold of EJBContext
      EJBContext currentEJBContext = CurrentInvocationContext.get().getEJBContext();
      // and return the timerservice of that context
      return currentEJBContext.getTimerService();
   }

}
