/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tutorial.callback.bean;

import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.jboss.tutorial.callback.bean.Customer;

public class CustomerCallbackListener {
    @PrePersist
    public void doPrePersist(Customer customer) {
        System.out.println("doPrePersist: About to create Customer: " + customer.getFirst() + " " + customer.getLast());
    }

    @PostPersist
    public void doPostPersist(Object customer) {
        System.out.println("doPostPersist: Created Customer: " + ((Customer)customer).getFirst() + " " + ((Customer)customer).getLast());
    }

    @PreRemove
    public void doPreRemove(Customer customer) {
        System.out.println("doPreRemove: About to delete Customer: " + customer.getFirst() + " " + customer.getLast());
    }

    @PostRemove
    public void doPostRemove(Customer customer) {
        System.out.println("doPostRemove: Deleted Customer: " + customer.getFirst() + " " + customer.getLast());
    }

    @PreUpdate
    public void doPreUpdate(Customer customer) {
        System.out.println("doPreUpdate: About to update Customer: " + customer.getFirst() + " " + customer.getLast());
    }

    @PostUpdate
    public void doPostUpdate(Customer customer) {
        System.out.println("doPostUpdate: Updated Customer: " + customer.getFirst() + " " + customer.getLast());
    }

    @PostLoad
    public void doPostLoad(Customer customer) {
        System.out.println("doPostLoad: Loaded Customer: " + customer.getFirst() + " " + customer.getLast());
    }
}

