/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tutorial.callback.bean;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jboss.tutorial.callback.bean.Customer;
import org.jboss.tutorial.callback.bean.CustomerDAO;
import org.jboss.tutorial.callback.bean.LifecycleInterceptor;

@Stateless
@Remote(value={CustomerDAO.class})
@Interceptors(value={LifecycleInterceptor.class})
public class CustomerDAOBean
implements CustomerDAO {
    @PersistenceContext
    private EntityManager manager;

    public int create(String first, String last, String street, String city, String state, String zip) {
        System.out.println("-- CustomerDAOBean.create()");
        Customer customer = new Customer(first, last, street, city, state, zip);
        this.manager.persist((Object)customer);
        return customer.getId();
    }

    public Customer find(int id) {
        System.out.println("-- CustomerDAOBean.find()");
        return (Customer)this.manager.find(Customer.class, (Object)id);
    }

    public List findByLastName(String last) {
        System.out.println("-- CustomerDAOBean.findByLastName(id)");
        return this.manager.createQuery("from Customer c where c.last = :last").setParameter("last", (Object)last).getResultList();
    }

    public void merge(Customer c) {
        System.out.println("-- CustomerDAOBean.merge()");
        this.manager.merge((Object)c);
    }

    public void delete(List l) {
        System.out.println("-- CustomerDAOBean.delete()");
        for (Customer c : l) {
            Customer mergedCustomer = (Customer)this.manager.merge((Object)c);
            this.manager.remove((Object)mergedCustomer);
        }
    }

    @PostConstruct
    public void postConstructCallback() {
        System.out.println("PostConstruct - Have EntityManager: " + (this.manager != null));
    }

    @PreDestroy
    public void preDestroyCallback() {
        System.out.println("PreDestory - Have EntityManager: " + (this.manager != null));
    }
}

