/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tutorial.entity.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.jboss.tutorial.entity.bean.LineItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="PURCHASE_ORDER")
public class Order
implements Serializable {
    private int id;
    private double total;
    private Collection<LineItem> lineItems;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public double getTotal() {
        return this.total;
    }

    public void setTotal(double total) {
        this.total = total;
    }

    public void addPurchase(String product, int quantity, double price) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        LineItem item = new LineItem();
        item.setOrder(this);
        item.setProduct(product);
        item.setQuantity(quantity);
        item.setSubtotal((double)quantity * price);
        this.lineItems.add(item);
        this.total += (double)quantity * price;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="order")
    public Collection<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(Collection<LineItem> lineItems) {
        this.lineItems = lineItems;
    }
}

