/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tutorial.extended.client;

import javax.naming.InitialContext;
import org.jboss.tutorial.extended.bean.Customer;
import org.jboss.tutorial.extended.bean.ShoppingCart;
import org.jboss.tutorial.extended.bean.StatelessRemote;

public class Client {
    public static InitialContext getInitialContext() throws Exception {
        return new InitialContext();
    }

    public static void testLongLivedSession() throws Exception {
        ShoppingCart test = (ShoppingCart)Client.getInitialContext().lookup("ShoppingCartBean/remote");
        StatelessRemote remote = (StatelessRemote)Client.getInitialContext().lookup("StatelessSessionBean/remote");
        long id = test.createCustomer();
        Customer c = remote.find(id);
        System.out.println("Created customer: " + c.getName());
        test.update();
        c = remote.find(id);
        System.out.println("ShoppingCartBean.customer should stay managed because we're in an extended PC: Customer.getName() == " + c.getName());
        test.update3();
        c = remote.find(id);
        System.out.println("Extended persistence contexts are propagated to nested EJB calls: Customer.getName() == " + c.getName());
        test.checkout();
    }

    public static void testWithFlushMode() throws Exception {
        ShoppingCart cart = (ShoppingCart)Client.getInitialContext().lookup("ShoppingCartBean/remote");
        StatelessRemote dao = (StatelessRemote)Client.getInitialContext().lookup("StatelessSessionBean/remote");
        long id = cart.createCustomer();
        Customer c = dao.find(id);
        System.out.println("Created customer: " + c.getName());
        cart.never();
        c = dao.find(id);
        System.out.println("Customer's name should still be William as pc was not yet flushed:  Customer.getName() == " + c.getName());
        cart.checkout();
        c = dao.find(id);
        System.out.println("Now that the pc has been flushed name should be 'Bob': Customer.getName() == " + c.getName());
    }

    public static void main(String[] args) throws Exception {
        Client.testWithFlushMode();
        Client.testLongLivedSession();
    }
}

