/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tutorial.ssl.client;

import javax.ejb.EJBAccessException;
import javax.naming.InitialContext;
import org.jboss.security.client.SecurityClient;
import org.jboss.security.client.SecurityClientFactory;
import org.jboss.tutorial.ssl.bean.Calculator;

public class Client {
    public static void main(String[] args) throws Exception {
        SecurityClient securityClient = SecurityClientFactory.getSecurityClient();
        securityClient.setSimple((Object)"kabir", (Object)"invalidpassword");
        securityClient.login();
        InitialContext ctx = new InitialContext();
        Calculator sslCalculator = (Calculator)ctx.lookup("CalculatorBean/remote");
        System.out.println("Invoking bean methods on a proxy through sslsocket");
        System.out.println("Kabir is a student.");
        System.out.println("Kabir types in the wrong password");
        try {
            System.out.println("1 + 1 = " + sslCalculator.add(1, 1));
            throw new RuntimeException("ERROR - User with incorrect password allowed to operate on bean");
        }
        catch (EJBAccessException ex) {
            System.out.println("Saw expected SecurityException: " + ex.getMessage());
            System.out.println("Kabir types in correct password.");
            System.out.println("Kabir does unchecked addition.");
            securityClient.logout();
            securityClient.setSimple((Object)"kabir", (Object)"validpassword");
            securityClient.login();
            System.out.println("1 + 1 = " + sslCalculator.add(1, 1));
            System.out.println("Kabir is not a teacher so he cannot do division");
            try {
                sslCalculator.divide(16, 4);
                throw new RuntimeException("ERROR - User with insufficient role was allowed to operate on bean");
            }
            catch (EJBAccessException ex2) {
                System.out.println("Caught expected EJBAccessException : " + ex2.getMessage());
                System.out.println("Kabir is a student, and students are allowed to do subtraction");
                System.out.println("1 - 1 = " + sslCalculator.subtract(1, 1));
                Calculator normalCalculator = (Calculator)ctx.lookup("CalculatorNormal");
                System.out.println("Invoking bean methods on a proxy through normal socket");
                System.out.println("Kabir is a student. So he can do addition");
                System.out.println("2 + 2 = " + normalCalculator.add(2, 2));
                return;
            }
        }
    }
}

