/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.jndi.deployers.resource.provider;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.jndi.deployers.resolver.EJBBinderResolutionResult;
import org.jboss.ejb3.jndi.deployers.resolver.EJBBinderResolver;
import org.jboss.ejb3.jndi.deployers.resolver.EJBReference;
import org.jboss.ejb3.jndi.deployers.resource.provider.EJBRefResource;
import org.jboss.switchboard.impl.resource.LinkRefResource;
import org.jboss.switchboard.javaee.environment.AnnotatedEJBRefType;
import org.jboss.switchboard.javaee.environment.JavaEEResourceType;
import org.jboss.switchboard.javaee.jboss.environment.JBossAnnotatedEJBRefType;
import org.jboss.switchboard.javaee.util.InjectionTargetUtil;
import org.jboss.switchboard.mc.spi.MCBasedResourceProvider;
import org.jboss.switchboard.spi.Resource;

public class AnnotatedEJBRefResourceProvider
implements MCBasedResourceProvider<JBossAnnotatedEJBRefType> {
    private EJBBinderResolver ejbBinderResolver;

    public AnnotatedEJBRefResourceProvider(EJBBinderResolver ejbBinderResolver) {
        this.ejbBinderResolver = ejbBinderResolver;
    }

    public Class<JBossAnnotatedEJBRefType> getEnvironmentEntryType() {
        return JBossAnnotatedEJBRefType.class;
    }

    public Resource provide(DeploymentUnit unit, JBossAnnotatedEJBRefType annotatedEjbRef) {
        String lookupName = annotatedEjbRef.getLookupName();
        if (lookupName != null && !lookupName.trim().isEmpty()) {
            return new LinkRefResource(lookupName, annotatedEjbRef.isIgnoreDependency());
        }
        String mappedName = annotatedEjbRef.getMappedName();
        if (mappedName != null && !mappedName.trim().isEmpty()) {
            return new LinkRefResource(mappedName, annotatedEjbRef.isIgnoreDependency());
        }
        String jndiName = annotatedEjbRef.getJNDIName();
        if (jndiName != null && !jndiName.trim().isEmpty()) {
            return new LinkRefResource(jndiName, annotatedEjbRef.isIgnoreDependency());
        }
        String beanInterface = this.getBeanInterfaceType(unit.getClassLoader(), (AnnotatedEJBRefType)annotatedEjbRef);
        EJBReference ejbReference = new EJBReference(unit, annotatedEjbRef.getBeanName(), beanInterface, mappedName, lookupName);
        EJBBinderResolutionResult result = this.ejbBinderResolver.resolveEJBBinder(unit, ejbReference);
        if (result == null) {
            throw new RuntimeException("Could not resolve @EJB reference: " + ejbReference + " for environment entry: " + annotatedEjbRef.getName() + " in unit " + unit);
        }
        return new EJBRefResource(result.getJNDIName(), result.getEJBBinderName());
    }

    private String getBeanInterfaceType(ClassLoader cl, AnnotatedEJBRefType annotatedEjbRef) {
        String explicitType = annotatedEjbRef.getBeanInterface();
        if (explicitType != null && !explicitType.trim().isEmpty()) {
            return explicitType;
        }
        Class type = InjectionTargetUtil.getInjectionTargetPropertyType((ClassLoader)cl, (JavaEEResourceType)annotatedEjbRef);
        return type == null ? null : type.getName();
    }
}

