/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.jndi.deployers.metadata;

import java.util.Collection;
import java.util.LinkedList;
import javax.naming.Context;
import org.jboss.ejb3.jndi.binder.metadata.SessionBeanType;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.reloaded.naming.spi.JavaEEComponent;
import org.jboss.reloaded.naming.spi.JavaEEModule;

public class SessionBeanTypeWrapper
implements SessionBeanType {
    private JBossSessionBeanMetaData sessionBeanMetaData;
    private ClassLoader classLoader;
    private Collection<Class<?>> businessLocals;
    private Collection<Class<?>> businessRemotes;
    private Class<?> home;
    private Class<?> localHome;
    private Class<?> ejbClass;
    private boolean isLocalBean;
    private JavaEEComponent delegate;

    public SessionBeanTypeWrapper(JBossSessionBeanMetaData sessionBeanMetaData, ClassLoader classLoader, JavaEEComponent delegate) throws ClassNotFoundException {
        this.sessionBeanMetaData = sessionBeanMetaData;
        this.classLoader = classLoader;
        this.delegate = delegate;
        this.businessLocals = SessionBeanTypeWrapper.convert((Collection<String>)sessionBeanMetaData.getBusinessLocals(), classLoader);
        this.businessRemotes = SessionBeanTypeWrapper.convert((Collection<String>)sessionBeanMetaData.getBusinessRemotes(), classLoader);
        this.home = SessionBeanTypeWrapper.convert(sessionBeanMetaData.getHome(), classLoader);
        this.localHome = SessionBeanTypeWrapper.convert(sessionBeanMetaData.getLocalHome(), classLoader);
        this.ejbClass = Class.forName(sessionBeanMetaData.getEjbClass(), true, classLoader);
        if (sessionBeanMetaData.getEjbJarMetaData().isEJB31() && sessionBeanMetaData instanceof JBossSessionBean31MetaData) {
            this.isLocalBean = ((JBossSessionBean31MetaData)sessionBeanMetaData).isNoInterfaceBean();
        }
    }

    private static Collection<Class<?>> convert(Collection<String> classNames, ClassLoader loader) throws ClassNotFoundException {
        if (classNames == null) {
            return null;
        }
        LinkedList classes = new LinkedList();
        for (String className : classNames) {
            classes.add(Class.forName(className, true, loader));
        }
        return classes;
    }

    private static Class<?> convert(String className, ClassLoader loader) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        return Class.forName(className, false, loader);
    }

    public Collection<Class<?>> getBusinessLocals() {
        return this.businessLocals;
    }

    public Collection<Class<?>> getBusinessRemotes() {
        return this.businessRemotes;
    }

    public Class<?> getEJBClass() {
        return this.ejbClass;
    }

    public Class<?> getHome() {
        return this.home;
    }

    public Class<?> getRemote() {
        throw new RuntimeException("NYI: org.jboss.ejb3.jndi.deployers.metadata.SessionBeanTypeWrapper.getRemote");
    }

    public Class<?> getLocal() {
        throw new RuntimeException("NYI: org.jboss.ejb3.jndi.deployers.metadata.SessionBeanTypeWrapper.getLocal");
    }

    public Class<?> getLocalHome() {
        return this.localHome;
    }

    public JBossSessionBeanMetaData getSessionBeanMetaData() {
        return this.sessionBeanMetaData;
    }

    public boolean isLocalBean() {
        return this.isLocalBean;
    }

    public Context getContext() {
        return this.delegate.getContext();
    }

    public JavaEEModule getModule() {
        return this.delegate.getModule();
    }

    public String getName() {
        return this.delegate.getName();
    }
}

