/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.jndi.deployers.resolver;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.jndi.deployers.EJBBinderIdentifierGenerator;
import org.jboss.ejb3.jndi.deployers.resolver.EJBBinderResolutionResult;
import org.jboss.ejb3.jndi.deployers.resolver.EJBBinderResolver;
import org.jboss.ejb3.jndi.deployers.resolver.EJBReference;
import org.jboss.logging.Logger;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ejb.jboss.InvokerBindingMetaData;
import org.jboss.metadata.ejb.jboss.InvokerBindingsMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossEntityBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;

public class ScopedEJBBinderResolver
implements EJBBinderResolver {
    private static Logger logger = Logger.getLogger(ScopedEJBBinderResolver.class);
    private JavaEEComponentInformer componentInformer;

    public ScopedEJBBinderResolver(JavaEEComponentInformer componentInformer) {
        this.componentInformer = componentInformer;
    }

    @Override
    public EJBBinderResolutionResult resolveEJBBinder(DeploymentUnit unit, EJBReference ejbRef) {
        return this.resolveEJBBinder(unit, new HashSet<DeploymentUnit>(), ejbRef);
    }

    private EJBBinderResolutionResult resolveEJBBinder(DeploymentUnit du, Collection<DeploymentUnit> alreadyScannedDUs, EJBReference reference) {
        DeploymentUnit parent;
        EJBBinderResolutionResult binderResoultionResult = this.findBinder(du, reference);
        if (binderResoultionResult != null) {
            return binderResoultionResult;
        }
        if (alreadyScannedDUs == null) {
            alreadyScannedDUs = new HashSet<DeploymentUnit>();
        }
        alreadyScannedDUs.add(du);
        List children = du.getChildren();
        if (children != null) {
            for (DeploymentUnit child : children) {
                if (alreadyScannedDUs.contains(child)) continue;
                binderResoultionResult = this.resolveEJBBinder(child, alreadyScannedDUs, reference);
                if (binderResoultionResult != null) {
                    return binderResoultionResult;
                }
                alreadyScannedDUs.add(child);
            }
        }
        if ((parent = du.getParent()) != null) {
            return this.resolveEJBBinder(parent, alreadyScannedDUs, reference);
        }
        return null;
    }

    private EJBBinderResolutionResult findBinder(DeploymentUnit du, EJBReference reference) {
        JBossMetaData metadata = (JBossMetaData)du.getAttachment("processed." + JBossMetaData.class.getName(), JBossMetaData.class);
        if (metadata == null && (metadata = (JBossMetaData)du.getAttachment(JBossMetaData.class)) == null) {
            return null;
        }
        logger.debug((Object)("Resolving reference for " + reference + " in " + metadata));
        ArrayList<JBossEnterpriseBeanMetaData> matches = new ArrayList<JBossEnterpriseBeanMetaData>();
        JBossEnterpriseBeansMetaData beans = metadata.getEnterpriseBeans();
        String resolvedInterface = null;
        for (JBossEnterpriseBeanMetaData bean : beans) {
            String intf = this.getMatchingInterface(reference, bean, du);
            if (intf == null) continue;
            resolvedInterface = intf;
            matches.add(bean);
            logger.debug((Object)("Found match in EJB " + bean.getEjbName() + " for " + reference));
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() > 1) {
            throw new RuntimeException("Specified reference " + reference + " was matched by more than one EJB: " + matches + ".  Specify beanName explciitly or ensure beanInterface is unique.");
        }
        JBossEnterpriseBeanMetaData resolvedBeanMetaData = (JBossEnterpriseBeanMetaData)matches.get(0);
        String jndiName = this.getJNDIName(du, resolvedBeanMetaData, resolvedInterface);
        String binderName = null;
        if (resolvedBeanMetaData.isSession()) {
            binderName = EJBBinderIdentifierGenerator.getEJBBinderName(this.componentInformer, du, resolvedBeanMetaData.getEjbName());
        }
        EJBBinderResolutionResult result = new EJBBinderResolutionResult(binderName, jndiName, resolvedBeanMetaData, resolvedInterface);
        logger.debug((Object)("Resolved reference: " + reference + " to: " + result));
        return result;
    }

    private String getMatchingInterface(EJBReference reference, JBossEnterpriseBeanMetaData beanMetaData, DeploymentUnit unit) {
        if (!beanMetaData.isSession() && !beanMetaData.isEntity()) {
            return null;
        }
        if (!this.acceptsEjbName(beanMetaData, reference, unit)) {
            return null;
        }
        if (this.hasNoInterfaceView(beanMetaData) && beanMetaData.getEjbClass().equals(reference.getBeanInterface())) {
            return beanMetaData.getEjbClass();
        }
        ClassLoader cl = unit.getClassLoader();
        Set<Class<?>> directlyEligibleInterfacesOnBean = this.getExposedInterfaces(beanMetaData, cl);
        String requestedInterface = reference.getBeanInterface();
        if (requestedInterface == null || requestedInterface.trim().isEmpty()) {
            throw new RuntimeException("beanInterface missing from ejb reference: " + reference);
        }
        Class<?> type = this.loadClass(requestedInterface, cl);
        if (directlyEligibleInterfacesOnBean.contains(type)) {
            return type.getName();
        }
        Class<?> resolvedInterface = null;
        boolean matchFound = false;
        for (Class<?> exposedIntf : directlyEligibleInterfacesOnBean) {
            if (!type.isAssignableFrom(exposedIntf)) continue;
            if (!matchFound) {
                resolvedInterface = exposedIntf;
                matchFound = true;
                continue;
            }
            throw new RuntimeException("beanInterface specified, " + type + ", is not unique within EJB " + beanMetaData.getEjbName());
        }
        return resolvedInterface == null ? null : resolvedInterface.getName();
    }

    private Set<Class<?>> getExposedInterfaces(JBossEnterpriseBeanMetaData enterpriseBean, ClassLoader cl) {
        if (enterpriseBean.isSession() && enterpriseBean instanceof JBossSessionBeanMetaData) {
            return this.getSessionBeanExposedInterfaces((JBossSessionBeanMetaData)enterpriseBean, cl);
        }
        if (enterpriseBean.isEntity() && enterpriseBean instanceof JBossEntityBeanMetaData) {
            return this.getEntityBeanExposedInterfaces((JBossEntityBeanMetaData)enterpriseBean, cl);
        }
        return new HashSet();
    }

    private Set<Class<?>> getSessionBeanExposedInterfaces(JBossSessionBeanMetaData smd, ClassLoader cl) {
        HashSet interfaces = new HashSet();
        BusinessLocalsMetaData businessLocals = smd.getBusinessLocals();
        BusinessRemotesMetaData businessRemotes = smd.getBusinessRemotes();
        String home = smd.getHome();
        String localHome = smd.getLocalHome();
        if (businessLocals != null) {
            for (String busLocal : businessLocals) {
                if (busLocal == null) continue;
                interfaces.add(this.loadClass(busLocal, cl));
            }
        }
        if (businessRemotes != null) {
            for (String busRemote : businessRemotes) {
                if (busRemote == null) continue;
                interfaces.add(this.loadClass(busRemote, cl));
            }
        }
        if (home != null && home.trim().length() > 0) {
            interfaces.add(this.loadClass(home, cl));
        }
        if (localHome != null && localHome.trim().length() > 0) {
            interfaces.add(this.loadClass(localHome, cl));
        }
        return interfaces;
    }

    private Set<Class<?>> getEntityBeanExposedInterfaces(JBossEntityBeanMetaData entityBean, ClassLoader cl) {
        String localHome;
        String home;
        String remote;
        HashSet interfaces = new HashSet();
        String local = entityBean.getLocal();
        if (local != null && !local.trim().isEmpty()) {
            interfaces.add(this.loadClass(local, cl));
        }
        if ((remote = entityBean.getRemote()) != null && remote.trim().isEmpty()) {
            interfaces.add(this.loadClass(remote, cl));
        }
        if ((home = entityBean.getHome()) != null && !home.trim().isEmpty()) {
            interfaces.add(this.loadClass(home, cl));
        }
        if ((localHome = entityBean.getLocalHome()) != null && !localHome.trim().isEmpty()) {
            interfaces.add(this.loadClass(localHome, cl));
        }
        return interfaces;
    }

    private String getModuleName(DeploymentUnit unit) {
        return this.componentInformer.getModuleName(unit);
    }

    private String getJNDIName(DeploymentUnit unit, JBossEnterpriseBeanMetaData beanMetaData, String interfaceFQN) {
        if (beanMetaData.isSession() && beanMetaData instanceof JBossSessionBeanMetaData) {
            return this.getGlobalJNDINameForSessionBean(unit, (JBossSessionBeanMetaData)beanMetaData, interfaceFQN);
        }
        if (beanMetaData.isEntity() && beanMetaData instanceof JBossEntityBeanMetaData) {
            return this.getJNDINameForEntityBean(unit, (JBossEntityBeanMetaData)beanMetaData, interfaceFQN);
        }
        return null;
    }

    private String getGlobalJNDINameForSessionBean(DeploymentUnit unit, JBossSessionBeanMetaData sessionBean, String interfaceFQN) {
        DeploymentUnit topLevelUnit;
        StringBuilder globalJNDIName = new StringBuilder("java:global/");
        DeploymentUnit deploymentUnit = topLevelUnit = unit.isTopLevel() ? unit : unit.getTopLevel();
        if (topLevelUnit.isAttachmentPresent(JBossAppMetaData.class)) {
            String earName = topLevelUnit.getSimpleName();
            earName = earName.substring(0, earName.length() - 4);
            globalJNDIName.append(earName);
            globalJNDIName.append("/");
        }
        String moduleName = this.getModuleName(unit);
        globalJNDIName.append(moduleName);
        globalJNDIName.append("/");
        globalJNDIName.append(sessionBean.getEjbName());
        if (interfaceFQN != null && !interfaceFQN.trim().isEmpty()) {
            globalJNDIName.append("!");
            globalJNDIName.append(interfaceFQN);
        }
        return globalJNDIName.toString();
    }

    private String getJNDINameForEntityBean(DeploymentUnit unit, JBossEntityBeanMetaData entityBean, String interfaceFQN) {
        InvokerBindingsMetaData invokerBindings = entityBean.determineInvokerBindings();
        if (invokerBindings == null || invokerBindings.isEmpty()) {
            return entityBean.getJndiName();
        }
        InvokerBindingMetaData invokerBinding = (InvokerBindingMetaData)invokerBindings.iterator().next();
        String jndiName = invokerBinding.getJndiName();
        if (jndiName == null || jndiName.isEmpty()) {
            jndiName = entityBean.getJndiName();
        }
        return jndiName;
    }

    private boolean hasNoInterfaceView(JBossEnterpriseBeanMetaData beanMetaData) {
        if (!beanMetaData.isSession() || !(beanMetaData instanceof JBossSessionBeanMetaData)) {
            return false;
        }
        JBossSessionBeanMetaData sessionBean = (JBossSessionBeanMetaData)beanMetaData;
        if (!this.isEJB31(sessionBean)) {
            return false;
        }
        if (!(sessionBean instanceof JBossSessionBean31MetaData)) {
            return false;
        }
        JBossSessionBean31MetaData sessionBean31 = (JBossSessionBean31MetaData)beanMetaData;
        return sessionBean31.isNoInterfaceBean();
    }

    private boolean isEJB31(JBossSessionBeanMetaData smd) {
        JBossMetaData jbossMetaData = smd.getJBossMetaData();
        return jbossMetaData.isEJB31();
    }

    private boolean acceptsEjbName(JBossEnterpriseBeanMetaData beanMetaData, EJBReference reference, DeploymentUnit du) {
        String ejbLink = reference.getBeanName();
        if (ejbLink == null || ejbLink.trim().isEmpty()) {
            return true;
        }
        if (ejbLink.endsWith("#") || ejbLink.endsWith("/")) {
            throw new RuntimeException("ejbLink: " + ejbLink + " in ejb reference: " + reference + " should not end with a / or a #");
        }
        int indexOfHash = ejbLink.indexOf("#");
        int indexOfForwardSlash = ejbLink.indexOf("/");
        if (indexOfHash == -1 && indexOfForwardSlash == -1) {
            return ejbLink.equals(beanMetaData.getEjbName());
        }
        if (indexOfHash != -1) {
            String path = ejbLink.substring(0, indexOfHash);
            String referencedEjbName = ejbLink.substring(indexOfHash + 1, ejbLink.length());
            if (path.equals(du.getSimpleName()) && referencedEjbName.equals(beanMetaData.getEjbName())) {
                return true;
            }
            DeploymentUnit ownerDeploymentUnit = reference.getOwnerDeploymentUnit();
            DeploymentUnit parentOfOwnerDU = null;
            if (ownerDeploymentUnit.isComponent()) {
                DeploymentUnit nonComponentDU = ownerDeploymentUnit.getParent();
                parentOfOwnerDU = nonComponentDU.getParent();
            } else {
                parentOfOwnerDU = ownerDeploymentUnit.getParent();
            }
            if (parentOfOwnerDU == null) {
                throw new RuntimeException("Cannot resolve ejbLink: " + ejbLink + " in reference " + reference + " from unit: " + ownerDeploymentUnit + " because the unit is a top-level unit and hence cannot have relative path reference");
            }
            DeploymentUnit relativeDU = this.getRelativeDeploymentUnit(parentOfOwnerDU, path);
            return du.getName().equals(relativeDU.getName()) && referencedEjbName.equals(beanMetaData.getEjbName());
        }
        if (indexOfForwardSlash != -1) {
            String moduleName = ejbLink.substring(0, indexOfForwardSlash);
            String referencedEjbName = ejbLink.substring(indexOfForwardSlash + 1, ejbLink.length());
            return moduleName.equals(this.getModuleName(du)) && referencedEjbName.equals(beanMetaData.getEjbName());
        }
        return ejbLink.equals(beanMetaData.getEjbName());
    }

    private DeploymentUnit getRelativeDeploymentUnit(DeploymentUnit current, String path) {
        String relativePathFromTopLevelDU = current.getRelativePath();
        relativePathFromTopLevelDU = relativePathFromTopLevelDU.isEmpty() ? path : relativePathFromTopLevelDU + File.pathSeparator + path;
        for (DeploymentUnit child : current.getChildren()) {
            if (!child.getRelativePath().equals(relativePathFromTopLevelDU)) continue;
            return child;
        }
        throw new IllegalArgumentException("Can't find a deployment unit with path " + path + " from unit " + current);
    }

    private Class<?> loadClass(String className, ClassLoader cl) {
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }
}

